/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.jira.displayer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jdom2.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.TableBlock;
import org.xwiki.rendering.block.TableCellBlock;
import org.xwiki.rendering.block.TableHeadCellBlock;
import org.xwiki.rendering.block.TableRowBlock;
import org.xwiki.rendering.block.VerbatimBlock;
import org.xwiki.rendering.internal.macro.jira.displayer.AbstractJIRADisplayer;
import org.xwiki.rendering.macro.jira.JIRAMacroParameters;

@Component
@Named(value="table")
@Singleton
public class TableJIRADisplayer
extends AbstractJIRADisplayer {
    private static final List<String> FIELDS = Arrays.asList("type", "key", "summary", "status", "created");

    @Override
    public List<Block> display(Collection<Element> issues, JIRAMacroParameters parameters) {
        ArrayList<TableRowBlock> rowBlocks = new ArrayList<TableRowBlock>();
        Map<String, String> fieldNames = this.getFieldNames(parameters);
        ArrayList<TableHeadCellBlock> headerCellBlocks = new ArrayList<TableHeadCellBlock>();
        for (String field : this.getFields(parameters)) {
            headerCellBlocks.add(new TableHeadCellBlock(Arrays.asList(new VerbatimBlock(this.getFieldName(field, fieldNames), true))));
        }
        rowBlocks.add(new TableRowBlock(headerCellBlocks));
        for (Element issue : issues) {
            ArrayList<TableCellBlock> dataCellBlocks = new ArrayList<TableCellBlock>();
            for (String field : this.getFields(parameters)) {
                dataCellBlocks.add(new TableCellBlock(this.getFieldDisplayer(field).displayField(field, issue)));
            }
            rowBlocks.add(new TableRowBlock(dataCellBlocks));
        }
        return Arrays.asList(new TableBlock(rowBlocks));
    }

    @Override
    protected List<String> getDefaultFields() {
        return FIELDS;
    }

    private String getFieldName(String field, Map<String, String> fieldNames) {
        String result = fieldNames.get(field);
        if (result == null) {
            result = field;
        }
        return result;
    }

    private Map<String, String> getFieldNames(JIRAMacroParameters parameters) {
        HashMap<String, String> fieldNames = new HashMap<String, String>();
        fieldNames.putAll(parameters.getDefaultFieldNames());
        if (parameters.getFieldNames() != null) {
            List<String> fields = this.getFields(parameters);
            for (int i = 0; i < fields.size(); ++i) {
                fieldNames.put(fields.get(i), parameters.getFieldNames().get(i));
            }
        }
        return fieldNames;
    }
}

