/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.migration;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.jdbc.migration.AbstractMigrationService;
import org.exoplatform.portal.jdbc.migration.AppReferencesMigrationService;
import org.exoplatform.portal.jdbc.migration.MigrationContext;
import org.exoplatform.portal.pom.config.POMDataStorage;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.listener.ListenerService;

public class SiteMigrationService
extends AbstractMigrationService {
    public static final String EVENT_LISTENER_KEY = "PORTAL_SITES_MIGRATION";

    public SiteMigrationService(InitParams initParams, POMDataStorage pomStorage, ModelDataStorage modelStorage, ListenerService listenerService, RepositoryService repoService, SettingService settingService, AppReferencesMigrationService appReferencesMigrationService) {
        super(initParams, pomStorage, modelStorage, listenerService, repoService, settingService, appReferencesMigrationService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doMigrate(PortalKey siteToMigrateKey) throws Exception {
        PortalData toMigrateSite = this.pomStorage.getPortalConfig(siteToMigrateKey);
        ContainerData portalLayoutContainer = this.migrateContainer(toMigrateSite.getPortalLayout());
        PortalData existingSite = this.modelStorage.getPortalConfig(siteToMigrateKey);
        String storageId = null;
        if (existingSite != null) {
            try {
                this.modelStorage.remove(existingSite);
                existingSite = null;
            }
            catch (Throwable e) {
                this.log.warn("Unable to reimport site {}::{}, update it instead", new Object[]{existingSite.getName(), existingSite.getType(), e});
                storageId = existingSite.getStorageId();
            }
            finally {
                MigrationContext.restartTransaction();
            }
        }
        PortalData toMigratePortalSite = new PortalData(storageId, toMigrateSite.getName(), toMigrateSite.getType(), toMigrateSite.getLocale(), toMigrateSite.getLabel(), toMigrateSite.getDescription(), toMigrateSite.getAccessPermissions(), toMigrateSite.getEditPermission(), toMigrateSite.getProperties(), toMigrateSite.getSkin(), portalLayoutContainer, toMigrateSite.getRedirects());
        if (StringUtils.isBlank((CharSequence)storageId)) {
            this.modelStorage.create(toMigratePortalSite);
        } else {
            this.modelStorage.save(toMigratePortalSite);
        }
        existingSite = this.modelStorage.getPortalConfig(siteToMigrateKey);
        this.broadcastListener(existingSite, existingSite.getKey().toString());
    }

    @Override
    public void doRemove(PortalKey siteToMigrateKey) throws Exception {
        PortalData data = this.pomStorage.getPortalConfig(siteToMigrateKey);
        if (data != null) {
            this.pomStorage.remove(data);
        }
        this.pomStorage.save();
    }

    @Override
    protected String getListenerKey() {
        return EVENT_LISTENER_KEY;
    }
}

