/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.operations.navigation;

import java.util.Collections;
import java.util.List;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.mop.management.exportimport.NavigationExportTask;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.PathTemplateFilter;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.exceptions.OperationException;
import org.gatein.management.api.exceptions.ResourceNotFoundException;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.api.operation.OperationContextDelegate;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.api.operation.ResultHandler;
import org.gatein.management.api.operation.StepResultHandler;
import org.gatein.management.api.operation.model.ExportResourceModel;
import org.gatein.management.api.operation.model.ExportTask;
import org.gatein.management.api.operation.model.ReadResourceModel;

public class FilteredNavigationExportResource {
    protected void execute(OperationContext operationContext, ResultHandler resultHandler, PathTemplateFilter filter) {
        BindingProvider bindingProvider = operationContext.getBindingProvider();
        Marshaller marshaller = bindingProvider.getMarshaller(PageNavigation.class, ContentType.XML);
        ManagedResource resource = operationContext.getManagedResource();
        final PathAddress address = operationContext.getAddress();
        final String operationName = operationContext.getOperationName();
        StepResultHandler<PageNavigation> stepResultHandler = new StepResultHandler<PageNavigation>(address){

            public void failed(String failureDescription) {
                if (address.equals((Object)this.getCurrentAddress())) {
                    throw new OperationException(operationName, "Navigation export failed. Reason: " + failureDescription);
                }
                throw new OperationException(operationName, "Navigation export failed. Reason: " + failureDescription + " [Step Address: " + this.getCurrentAddress() + "]");
            }

            protected void doCompleted(PageNavigation result) {
                if (this.getResults().isEmpty()) {
                    super.doCompleted((Object)result);
                } else {
                    PageNavigation navigation = (PageNavigation)this.getResults().get(0);
                    FilteredNavigationExportResource.this.merge(navigation, result);
                }
            }
        };
        try {
            this.executeHandlers(resource, operationContext, address, "read-config", stepResultHandler, filter, true);
            List results = stepResultHandler.getResults();
            if (results.isEmpty()) {
                resultHandler.completed((Object)new ExportResourceModel(Collections.emptyList()));
            } else {
                NavigationExportTask task = new NavigationExportTask((PageNavigation)stepResultHandler.getResults().get(0), (Marshaller<PageNavigation>)marshaller);
                resultHandler.completed((Object)new ExportResourceModel(new ExportTask[]{task}));
            }
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (OperationException e) {
            throw new OperationException(e.getOperationName(), this.getStepMessage(e, address, stepResultHandler), (Throwable)e);
        }
        catch (Throwable t) {
            throw new OperationException(operationName, this.getStepMessage(t, address, stepResultHandler), t);
        }
    }

    private void executeHandlers(ManagedResource resource, OperationContext operationContext, PathAddress address, String operationName, StepResultHandler<PageNavigation> stepResultHandler, PathTemplateFilter filter, boolean root) {
        OperationHandler handler = resource.getOperationHandler(address, operationName);
        if (handler != null && !root && address.accepts(filter)) {
            handler.execute(operationContext, stepResultHandler);
        } else {
            OperationHandler readResource = resource.getOperationHandler(address, "read-resource");
            BasicResultHandler readResourceResult = new BasicResultHandler();
            readResource.execute((OperationContext)new OperationContextDelegate(operationContext){

                public String getOperationName() {
                    return "read-resource";
                }
            }, (ResultHandler)readResourceResult);
            if (readResourceResult.getFailureDescription() != null) {
                throw new OperationException(operationName, "Failure '" + readResourceResult.getFailureDescription() + "' encountered executing " + "read-resource");
            }
            Object model = readResourceResult.getResult();
            if (!(model instanceof ReadResourceModel)) {
                throw new RuntimeException("Was expecting " + ReadResourceModel.class + " to be returned for operation " + "read-resource" + " at address " + address);
            }
            for (String child : ((ReadResourceModel)model).getChildren()) {
                final PathAddress childAddress = address.append(child);
                OperationContextDelegate childContext = new OperationContextDelegate(operationContext){

                    public PathAddress getAddress() {
                        return childAddress;
                    }
                };
                this.executeHandlers(resource, (OperationContext)childContext, childAddress, operationName, (StepResultHandler<PageNavigation>)stepResultHandler.next(childAddress), filter, false);
            }
        }
    }

    private String getStepMessage(Throwable t, PathAddress originalAddress, StepResultHandler<PageNavigation> stepResultHandler) {
        String message;
        String string = message = t.getMessage() == null ? "Step operation failure" : t.getMessage();
        if (originalAddress.equals((Object)stepResultHandler.getCurrentAddress())) {
            return message;
        }
        return message + " [Step Address: " + stepResultHandler.getCurrentAddress() + "]";
    }

    private void merge(PageNavigation navigation, PageNavigation result) {
        for (NavigationFragment fragment : result.getFragments()) {
            if (fragment.getParentURI() != null) {
                NavigationFragment found = this.findFragment(navigation, fragment.getParentURI());
                if (found == null) {
                    navigation.addFragment(fragment);
                    continue;
                }
                found.getNodes().addAll(fragment.getNodes());
                continue;
            }
            navigation.addFragment(fragment);
        }
    }

    private NavigationFragment findFragment(PageNavigation navigation, String parentUri) {
        for (NavigationFragment fragment : navigation.getFragments()) {
            if (!fragment.getParentURI().equals(parentUri)) continue;
            return fragment;
        }
        return null;
    }

    private static class BasicResultHandler
    implements ResultHandler {
        private Object result;
        private String failureDescription;

        private BasicResultHandler() {
        }

        public void completed(Object result) {
            this.result = result;
        }

        public void failed(String failureDescription) {
            this.failureDescription = failureDescription;
        }

        public Object getResult() {
            return this.result;
        }

        public String getFailureDescription() {
            return this.failureDescription;
        }
    }
}

