/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.internal.CommonsConfigurationSource;
import org.xwiki.environment.Environment;

@Component
@Named(value="xwikiproperties")
@Singleton
public class XWikiPropertiesConfigurationSource
extends CommonsConfigurationSource
implements Initializable {
    private static final String XWIKI_PROPERTIES_FILE = "/WEB-INF/xwiki.properties";
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        URL xwikiPropertiesUrl = null;
        try {
            xwikiPropertiesUrl = this.environment.getResource(XWIKI_PROPERTIES_FILE);
            if (xwikiPropertiesUrl != null) {
                this.setConfiguration((Configuration)new PropertiesConfiguration(xwikiPropertiesUrl));
            } else {
                this.logger.debug("No configuration file [{}] found. Using default configuration values.", (Object)XWIKI_PROPERTIES_FILE);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to load configuration file [{}]. Using default configuration values. Internal error [{}]", (Object)XWIKI_PROPERTIES_FILE, (Object)e.getMessage());
        }
        if (xwikiPropertiesUrl == null) {
            this.setConfiguration((Configuration)new BaseConfiguration());
        }
    }
}

