/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.upgrade.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NewsJcrNodePermissionsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger((String)NewsJcrNodePermissionsUpgradePlugin.class.getName());
    private NodeHierarchyCreator nodeHierarchyCreator;
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private int newsJcrNodesUpdatedCount;
    public static final String NEWS_NODES_FOLDER = "News";
    public static final String ADMINISTRATORS_IDENTITY = "*:/platform/administrators";

    public NewsJcrNodePermissionsUpgradePlugin(InitParams initParams, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        super(initParams);
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        log.info((Object)"Start upgrade of news jcr nodes");
        try (SessionProvider sessionProvider = null;){
            sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
            String spacesNodePath = this.nodeHierarchyCreator.getJcrPath("groupsPath") + "/spaces";
            Node spacesRootNode = (Node)session.getItem(spacesNodePath);
            NodeIterator iter = spacesRootNode.getNodes();
            while (iter.hasNext()) {
                Node spaceNode = iter.nextNode();
                if (!spaceNode.hasNode(NEWS_NODES_FOLDER)) continue;
                Node spaceNewsRootNode = spaceNode.getNode(NEWS_NODES_FOLDER);
                ((ExtendedNode)spaceNewsRootNode).removePermission(ADMINISTRATORS_IDENTITY);
                spaceNewsRootNode.save();
                ++this.newsJcrNodesUpdatedCount;
            }
            log.info("End upgrade of '{}' news jcr nodes. It took {} ms", new Object[]{this.newsJcrNodesUpdatedCount, System.currentTimeMillis() - startupTime});
        }
    }

    public int getNewsJcrNodesUpdatedCount() {
        return this.newsJcrNodesUpdatedCount;
    }
}

