/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.chromattic.common.logging.Logger;
import org.chromattic.core.jcr.AbstractLinkManager;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.jcr.PathLinkManager;
import org.chromattic.core.jcr.ReferenceLinkManager;
import org.chromattic.core.jcr.SessionWrapper;
import org.chromattic.spi.jcr.SessionLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionWrapperImpl
implements SessionWrapper {
    private static final Logger log = Logger.getLogger(SessionWrapperImpl.class);
    private Session session;
    private AbstractLinkManager[] linkMgrs;
    private SessionLifeCycle sessionLifeCycle;
    private final boolean hasPropertyOptimized;
    private final boolean hasNodeOptimized;

    public SessionWrapperImpl(SessionLifeCycle sessionLifeCycle, Session session, boolean hasPropertyOptimized, boolean hasNodeOptimized) {
        this.hasPropertyOptimized = hasPropertyOptimized;
        this.hasNodeOptimized = hasNodeOptimized;
        this.sessionLifeCycle = sessionLifeCycle;
        this.session = session;
        this.linkMgrs = new AbstractLinkManager[]{new ReferenceLinkManager(session), new PathLinkManager(session)};
    }

    @Override
    public Iterator<Property> getProperties(Node node) throws RepositoryException {
        PropertyIterator properties = node.getProperties();
        return properties;
    }

    @Override
    public boolean hasProperty(Node node, String relPath) throws RepositoryException {
        return node.hasProperty(relPath);
    }

    @Override
    public Property getProperty(Node node, String relPath) throws RepositoryException {
        if (this.hasPropertyOptimized) {
            try {
                return node.getProperty(relPath);
            }
            catch (PathNotFoundException e) {
                return null;
            }
        }
        if (node.hasProperty(relPath)) {
            return node.getProperty(relPath);
        }
        return null;
    }

    @Override
    public Node getNode(String path) throws RepositoryException {
        try {
            Item item = this.session.getItem(path);
            if (item instanceof Node) {
                return (Node)item;
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Node getNode(Node node, String relPath) throws RepositoryException {
        if (this.hasNodeOptimized) {
            try {
                return node.getNode(relPath);
            }
            catch (PathNotFoundException e) {
                return null;
            }
        }
        if (node.hasNode(relPath)) {
            return node.getNode(relPath);
        }
        return null;
    }

    @Override
    public NodeType getNodeType(String nodeTypeName) throws RepositoryException {
        NodeTypeManager mgr = this.session.getWorkspace().getNodeTypeManager();
        return mgr.getNodeType(nodeTypeName);
    }

    @Override
    public Node addNode(Node parentNode, String relPath, String primartyNodeTypeName, List<String> mixinNodeTypeNames) throws RepositoryException {
        Node childNode = parentNode.addNode(relPath, primartyNodeTypeName);
        if (mixinNodeTypeNames instanceof RandomAccess) {
            int size = mixinNodeTypeNames.size();
            for (int i = 0; i < size; ++i) {
                String mixinNodeTypeName = mixinNodeTypeNames.get(i);
                childNode.addMixin(mixinNodeTypeName);
            }
        } else {
            for (String mixinNodeTypeName : mixinNodeTypeNames) {
                childNode.addMixin(mixinNodeTypeName);
            }
        }
        return childNode;
    }

    @Override
    public void move(Node srcNode, Node dstNode, String dstName) throws RepositoryException {
        String dstPath = dstNode.getPath() + "/" + dstName;
        this.session.move(srcNode.getPath(), dstPath);
    }

    @Override
    public void orderBefore(Node parentNode, Node srcNode, Node dstNode) throws RepositoryException {
        if (dstNode != null) {
            parentNode.orderBefore(srcNode.getName(), dstNode.getName());
        } else {
            long size = parentNode.getNodes().getSize();
            if (size > 1L) {
                parentNode.orderBefore(srcNode.getName(), null);
            }
        }
    }

    @Override
    public Node getNodeByUUID(String uuid) throws RepositoryException {
        try {
            return this.session.getNodeByUUID(uuid);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    @Override
    public Node getParent(Node childNode) throws RepositoryException {
        return childNode.getParent();
    }

    @Override
    public Iterator<Node> getChildren(Node parentNode) throws RepositoryException {
        return parentNode.getNodes();
    }

    @Override
    public Node getChild(Node parentNode, String name) throws RepositoryException {
        if (parentNode.hasNode(name)) {
            return parentNode.getNode(name);
        }
        return null;
    }

    @Override
    public boolean hasChild(Node parentNode, String name) throws RepositoryException {
        return parentNode.hasNode(name);
    }

    @Override
    public void remove(Node node) throws RepositoryException {
        this.cleanReferencesForRemoval(node);
        node.remove();
    }

    @Override
    public boolean canAddMixin(Node node, String mixinTypeName) throws RepositoryException {
        return node.canAddMixin(mixinTypeName);
    }

    @Override
    public void addMixin(Node node, String mixinTypeName) throws RepositoryException {
        node.addMixin(mixinTypeName);
    }

    @Override
    public boolean removeMixin(Node node, String mixinTypeName) throws RepositoryException {
        try {
            node.removeMixin(mixinTypeName);
            return true;
        }
        catch (NoSuchNodeTypeException ignore) {
            return false;
        }
    }

    @Override
    public boolean haxMixin(Node node, String mixinTypeName) throws RepositoryException {
        return node.isNodeType(mixinTypeName);
    }

    public void cleanReferencesForRemoval(Node node) throws RepositoryException {
        Property property;
        NodeIterator i = node.getNodes();
        while (i.hasNext()) {
            Node child = i.nextNode();
            this.cleanReferencesForRemoval(child);
        }
        i = node.getReferences();
        while (i.hasNext()) {
            property = i.nextProperty();
            property.setValue((Node)null);
        }
        i = node.getProperties();
        while (i.hasNext()) {
            property = i.nextProperty();
            if (property.getType() == 9) {
                this.linkMgrs[LinkType.REFERENCE.index].setReferenced(node, property.getName(), null);
                continue;
            }
            if (property.getType() != 8) continue;
            this.linkMgrs[LinkType.PATH.index].setReferenced(node, property.getName(), null);
        }
    }

    @Override
    public void save() throws RepositoryException {
        this.sessionLifeCycle.save(this.session);
        for (AbstractLinkManager mgr : this.linkMgrs) {
            mgr.clear();
        }
    }

    @Override
    public Node getReferenced(Node referent, String propertyName, LinkType linkType) throws RepositoryException {
        return this.linkMgrs[linkType.index].getReferenced(referent, propertyName);
    }

    @Override
    public Node setReferenced(Node referent, String propertyName, Node referenced, LinkType linkType) throws RepositoryException {
        return this.linkMgrs[linkType.index].setReferenced(referent, propertyName, referenced);
    }

    @Override
    public Iterator<Node> getReferents(Node referenced, String propertyName, LinkType linkType) throws RepositoryException {
        return this.linkMgrs[linkType.index].getReferents(referenced, propertyName);
    }

    public int hashCode() {
        return this.session.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SessionWrapperImpl) {
            SessionWrapperImpl that = (SessionWrapperImpl)obj;
            return this.session == that.session;
        }
        return false;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public boolean isClosed() {
        return this.session == null;
    }

    @Override
    public void close() {
        if (this.session != null) {
            for (AbstractLinkManager mgr : this.linkMgrs) {
                mgr.clear();
            }
            this.sessionLifeCycle.close(this.session);
            this.session = null;
        }
    }

    @Override
    public Query createQuery(String statement) throws RepositoryException {
        QueryManager queryMgr = this.session.getWorkspace().getQueryManager();
        return queryMgr.createQuery(statement, "sql");
    }

    @Override
    public QueryResult executeQuery(Query query, Long offset, Long limit) throws RepositoryException {
        if (offset != null && offset > 0L) {
            this.invokeLongSetter(query, "setOffset", offset);
        }
        if (limit != null && limit >= 0L) {
            this.invokeLongSetter(query, "setLimit", limit);
        }
        return query.execute();
    }

    private int invokeIntGetter(Object o, String methodName) {
        Class<?> clazz = o.getClass();
        int hits = -1;
        try {
            Method getter = clazz.getMethod(methodName, new Class[0]);
            Class<?> ret = getter.getReturnType();
            if (ret.equals(Integer.TYPE)) {
                hits = (Integer)getter.invoke(o, new Object[0]);
            }
        }
        catch (NoSuchMethodException ignore) {
            log.trace("Could not find method " + methodName + " on " + clazz.getName(), (Throwable)ignore);
        }
        catch (Exception e) {
            log.error("Could not invoke " + methodName + " of class " + clazz.getName() + " on " + o, (Throwable)e);
        }
        return hits;
    }

    private void invokeLongSetter(Object o, String methodName, Long value) {
        Class<?> clazz = o.getClass();
        try {
            Method setter = clazz.getMethod(methodName, Long.TYPE);
            setter.invoke(o, value);
        }
        catch (NoSuchMethodException ignore) {
            log.trace("Could not find method " + methodName + " on " + clazz.getName(), (Throwable)ignore);
        }
        catch (Exception e) {
            log.error("Could not invoke " + methodName + " of class " + clazz.getName() + " on " + o + " with value " + value, (Throwable)e);
        }
    }
}

