/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.page;

import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.ExoDataCache;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageServiceException;
import org.exoplatform.portal.mop.page.PageServiceImpl;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.listener.ListenerService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.transaction.JTAUserTransactionLifecycleService;

public class PageServiceWrapper
implements PageService {
    private static final Logger log = LoggerFactory.getLogger(PageServiceWrapper.class);
    private final PageServiceImpl service;
    private final POMSessionManager manager;
    private final ListenerService listenerService;

    public PageServiceWrapper(POMSessionManager manager, ListenerService listenerService) {
        this.service = new PageServiceImpl(manager);
        this.manager = manager;
        this.listenerService = listenerService;
    }

    public PageServiceWrapper(POMSessionManager manager, ListenerService listenerService, CacheService cacheService) {
        this.service = new PageServiceImpl(manager, new ExoDataCache(cacheService));
        this.manager = manager;
        this.listenerService = listenerService;
    }

    public PageContext loadPage(PageKey key) {
        return this.service.loadPage(key);
    }

    public List<PageContext> loadPages(SiteKey siteKey) throws NullPointerException, PageServiceException {
        return this.service.loadPages(siteKey);
    }

    public boolean savePage(PageContext page) {
        boolean created = this.service.savePage(page);
        if (created) {
            this.notify("org.exoplatform.portal.mop.page.page_created", page.key);
        } else {
            this.notify("org.exoplatform.portal.mop.page.page_updated", page.key);
        }
        return created;
    }

    public boolean destroyPage(PageKey key) {
        boolean destroyed = this.service.destroyPage(key);
        if (destroyed) {
            this.notify("org.exoplatform.portal.mop.page.page_destroyed", key);
        }
        return destroyed;
    }

    public PageContext clone(PageKey src, PageKey dst) {
        PageContext pageContext = this.service.clone(src, dst);
        this.notify("org.exoplatform.portal.mop.page.page_created", dst);
        return pageContext;
    }

    public QueryResult<PageContext> findPages(int offset, int limit, SiteType siteType, String siteName, String pageName, String pageTitle) {
        try {
            POMSession pomSession;
            JTAUserTransactionLifecycleService jtaUserTransactionLifecycleService = (JTAUserTransactionLifecycleService)PortalContainer.getInstance().getComponentInstanceOfType(JTAUserTransactionLifecycleService.class);
            if (jtaUserTransactionLifecycleService.getUserTransaction().getStatus() == 0 && (pomSession = this.manager.getSession()).isModified()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Active JTA transaction found. Going to sync MOP session and JTA transaction");
                }
                pomSession.save();
                jtaUserTransactionLifecycleService.finishJTATransaction();
                jtaUserTransactionLifecycleService.beginJTATransaction();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error during sync of JTA transaction", (Throwable)e);
        }
        return this.service.findPages(offset, limit, siteType, siteName, pageName, pageTitle);
    }

    private void notify(String name, PageKey key) {
        try {
            this.listenerService.broadcast(name, (Object)this, (Object)key);
        }
        catch (Exception e) {
            log.error((Object)("Error when delivering notification " + name + " for page " + key), (Throwable)e);
        }
    }
}

