/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.DataCache;

class InvalidationBridge {
    private final DataCache cache;
    private ObservationManager mgr;
    private final EventListenerImpl portalBridge;
    private final EventListenerImpl groupBridge;
    private final EventListenerImpl userBridge;

    public InvalidationBridge(DataCache cache) {
        this.cache = cache;
        this.portalBridge = new EventListenerImpl("mop:portalsites", SiteType.PORTAL);
        this.groupBridge = new EventListenerImpl("mop:groupsites", SiteType.GROUP);
        this.userBridge = new EventListenerImpl("mop:usersites", SiteType.USER);
    }

    void start(Session session) throws RepositoryException {
        this.mgr = session.getWorkspace().getObservationManager();
        this.portalBridge.register(this.mgr);
        this.groupBridge.register(this.mgr);
        this.userBridge.register(this.mgr);
    }

    void stop() {
        this.portalBridge.unregister();
        this.groupBridge.unregister();
        this.userBridge.unregister();
    }

    private class EventListenerImpl
    implements EventListener {
        private final String nodeType;
        private final SiteType type;
        private ObservationManager mgr;

        private EventListenerImpl(String nodeType, SiteType type) {
            this.nodeType = nodeType;
            this.type = type;
        }

        void register(ObservationManager mgr) throws RepositoryException {
            mgr.addEventListener((EventListener)this, 2, "/", true, null, new String[]{this.nodeType}, false);
            this.mgr = mgr;
        }

        void unregister() {
            if (this.mgr != null) {
                try {
                    this.mgr.removeEventListener((EventListener)this);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }

        public void onEvent(EventIterator events) {
            InvalidationBridge.this.cache.clear();
        }
    }
}

