/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;

public class WikiGlobalPortalSiteUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(WikiGlobalPortalSiteUpgradePlugin.class);
    private PortalContainer container;
    private DataStorage dataStorage;
    private UserPortalConfigService portalConfigService;
    private WikiService wikiService;
    private EntityManagerService entityManagerService;

    public WikiGlobalPortalSiteUpgradePlugin(PortalContainer container, WikiService wikiService, UserPortalConfigService portalConfigService, DataStorage dataStorage, EntityManagerService entityManagerService, InitParams initParams) {
        super(initParams);
        this.container = container;
        this.wikiService = wikiService;
        this.portalConfigService = portalConfigService;
        this.dataStorage = dataStorage;
        this.entityManagerService = entityManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String globalPortal = this.portalConfigService.getGlobalPortal();
            Wiki globalSiteWiki = this.wikiService.getWikiByTypeAndOwner(PortalConfig.PORTAL_TYPE, globalPortal);
            if (globalSiteWiki == null) {
                LOG.info((Object)"--- Global Wiki Site migration: no global site wiki, nothing to migrate");
                return;
            }
            String defaultPortal = this.portalConfigService.getDefaultPortal();
            LOG.info("-- Global Wiki Site migration: Start updating wiki owner '{}' permissions to use owner '{}' default permissions", new Object[]{globalPortal, defaultPortal});
            this.updateGlobalSiteWikiPermissions(globalPortal, defaultPortal, globalSiteWiki);
            this.updateGlobalSiteWikiPagesPermissions(globalPortal, defaultPortal);
            LOG.info("-- Global Wiki Site migration: End updating wiki owner '{}' permissions to use owner '{}' default permissions", new Object[]{globalPortal, defaultPortal});
            Wiki defaultSiteWiki = this.wikiService.getWikiByTypeAndOwner(PortalConfig.PORTAL_TYPE, defaultPortal);
            if (defaultSiteWiki != null) {
                LOG.info((Object)"-- Global Wiki Site migration: default site has a wiki, the migration will not proceed");
                return;
            }
            LOG.info("-- Global Wiki Site migration: Start updating wiki from owner '{}' to owner '{}'", new Object[]{globalPortal, defaultPortal});
            EntityManager entityManager = this.entityManagerService.getEntityManager();
            boolean transactionStarted = false;
            if (entityManager.getTransaction() == null || !entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().begin();
                transactionStarted = true;
            }
            try {
                this.updatePageMoveEntities(globalPortal, defaultPortal);
                this.updatePageEntities(globalPortal, defaultPortal);
                this.updateWikiEntity(globalPortal, defaultPortal);
            }
            finally {
                if (transactionStarted) {
                    entityManager.getTransaction().commit();
                }
            }
            LOG.info("-- Global Wiki Site migration: End updating wiki from owner '{}' to owner '{}'", new Object[]{globalPortal, defaultPortal});
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while migrating global site wiki", e);
        }
        finally {
            RequestLifeCycle.end();
        }
        this.restartTransaction();
    }

    private List<PermissionEntry> getDefaultSitePermissions(String defaultPortal) throws WikiException {
        List<PermissionEntry> wikiDefaultPermissions = this.wikiService.getWikiDefaultPermissions(PortalConfig.PORTAL_TYPE, defaultPortal);
        wikiDefaultPermissions = Collections.unmodifiableList(wikiDefaultPermissions);
        return wikiDefaultPermissions;
    }

    private void updateGlobalSiteWikiPagesPermissions(String globalPortal, String defaultPortal) throws Exception {
        List<PermissionEntry> pageDefaultPermissions = this.getPageDefaultPermissions(defaultPortal);
        List pages = this.wikiService.getPagesOfWiki(PortalConfig.PORTAL_TYPE, globalPortal);
        LOG.info("---- Global Wiki Site migration: Start updating global site wiki '{}' pages permissions updated to use default site permissions", new Object[]{pages.size()});
        for (Page page : pages) {
            List pagePermissions = page.getPermissions();
            if (pagePermissions != null && pagePermissions.stream().anyMatch(permissionEntry -> StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)permissionEntry.getId()))) {
                page.setPermissions(pageDefaultPermissions);
                this.wikiService.updatePage(page, PageUpdateType.EDIT_PAGE_PERMISSIONS);
                LOG.info("----- Global Wiki Site migration: global site wiki page '{}' permissions updated to use default site permissions", new Object[]{page.getName()});
                continue;
            }
            LOG.info("----- Global Wiki Site migration: global site wiki page '{}' permissions NOT updated since it doesn't have permissions to 'ANY'", new Object[]{page.getName()});
        }
        LOG.info("---- Global Wiki Site migration: End updating global site wiki '{}' pages permissions updated to use default site permissions", new Object[]{pages.size()});
    }

    private void updateGlobalSiteWikiPermissions(String globalPortal, String defaultPortal, Wiki globalSiteWiki) throws WikiException {
        List<PermissionEntry> wikiDefaultPermissions = this.getDefaultSitePermissions(defaultPortal);
        List globalSitePermissions = globalSiteWiki.getPermissions();
        if (globalSitePermissions != null && globalSitePermissions.stream().anyMatch(permissionEntry -> StringUtils.equals((CharSequence)IdentityConstants.ANY, (CharSequence)permissionEntry.getId()))) {
            this.wikiService.updateWikiPermission(PortalConfig.PORTAL_TYPE, globalPortal, wikiDefaultPermissions);
            LOG.info((Object)"---- Global Wiki Site migration: global site wiki permissions updated to use default site permissions");
        } else {
            LOG.info((Object)"---- Global Wiki Site migration: global site wiki permissions NOT updated since it doesn't have permissions to 'ANY'");
        }
    }

    private void updatePageEntities(String globalPortal, String defaultPortal) {
        Query updatePageQuery = this.entityManagerService.getEntityManager().createQuery("UPDATE WikiPageEntity p SET p.owner = '" + defaultPortal + "' WHERE p.owner = '" + globalPortal + "'");
        int updatedPageLines = updatePageQuery.executeUpdate();
        LOG.info("---- Global Wiki Site migration: {} pages updated", new Object[]{updatedPageLines});
    }

    private void updateWikiEntity(String globalPortal, String defaultPortal) {
        Query updateWikiQuery = this.entityManagerService.getEntityManager().createQuery("UPDATE WikiWikiEntity w SET w.owner = '" + defaultPortal + "' WHERE w.owner = '" + globalPortal + "'");
        int updatedWikiLines = updateWikiQuery.executeUpdate();
        LOG.info("---- Global Wiki Site migration: {} wiki updated", new Object[]{updatedWikiLines});
    }

    private void updatePageMoveEntities(String globalPortal, String defaultPortal) {
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        Query updatePageMoveQuery = entityManager.createQuery("UPDATE WikiPageMoveEntity pm SET pm.wikiOwner = '" + defaultPortal + "' WHERE pm.wikiOwner = '" + globalPortal + "'");
        int updatedPageMoveLines = updatePageMoveQuery.executeUpdate();
        LOG.info("---- Global Wiki Site migration: {} PageMove updated", new Object[]{updatedPageMoveLines});
    }

    private void restartTransaction() {
        int i = 0;
        boolean success = true;
        do {
            try {
                RequestLifeCycle.end();
                ++i;
            }
            catch (IllegalStateException e) {
                success = false;
            }
        } while (success);
        for (int j = 0; j < i; ++j) {
            RequestLifeCycle.begin((ExoContainer)this.container);
        }
    }

    private List<PermissionEntry> getPageDefaultPermissions(String wikiOwner) throws Exception {
        Permission[] allPermissions = new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, true)};
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        for (Map.Entry entry : Utils.getACLForAdmins().entrySet()) {
            PermissionEntry permissionEntry = new PermissionEntry((String)entry.getKey(), "", (IDType)entry.getValue(), allPermissions);
            permissionEntries.add(permissionEntry);
        }
        PortalConfig portalConfig = this.dataStorage.getPortalConfig(wikiOwner);
        PermissionEntry portalPermissionEntry = new PermissionEntry(portalConfig.getEditPermission(), "", IDType.MEMBERSHIP, allPermissions);
        permissionEntries.add(portalPermissionEntry);
        String[] accessPermissions = portalConfig.getAccessPermissions();
        if (accessPermissions != null && accessPermissions.length > 0) {
            Permission[] viewPermissions = new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, false)};
            for (String permissionExpression : accessPermissions) {
                IDType idType = null;
                if (StringUtils.equals((CharSequence)"Everyone", (CharSequence)permissionExpression)) continue;
                idType = StringUtils.contains((CharSequence)permissionExpression, (CharSequence)"/") && StringUtils.contains((CharSequence)permissionExpression, (CharSequence)":") ? IDType.MEMBERSHIP : (StringUtils.contains((CharSequence)permissionExpression, (CharSequence)"/") ? IDType.GROUP : IDType.USER);
                PermissionEntry accessPermissionEntry = new PermissionEntry(permissionExpression, "", idType, viewPermissions);
                permissionEntries.add(accessPermissionEntry);
            }
        }
        return permissionEntries;
    }
}

