/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PopularSpacesRemovePreferences
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(PopularSpacesRemovePreferences.class);
    private static final String APPLICATION_CONTENT_ID = "gamification-portlets/PopularSpaces";
    private EntityManagerService entityManagerService;
    private boolean portletUpdated = false;

    public PopularSpacesRemovePreferences(EntityManagerService entityManagerService, InitParams initParams) {
        super(initParams);
        this.entityManagerService = entityManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info("Start upgrade of Popular spaces portlet: {}", new Object[]{APPLICATION_CONTENT_ID});
        long startupTime = System.currentTimeMillis();
        boolean transactionStarted = false;
        PortalContainer container = PortalContainer.getInstance();
        RequestLifeCycle.begin((ExoContainer)container);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        try {
            String sqlString;
            Query nativeQuery;
            int update;
            if (!entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().begin();
                transactionStarted = true;
            }
            if ((update = (nativeQuery = entityManager.createNativeQuery(sqlString = "UPDATE PORTAL_WINDOWS w SET w.CUSTOMIZATION = NULL WHERE w.CONTENT_ID = 'gamification-portlets/PopularSpaces'")).executeUpdate()) != 0) {
                LOG.info((Object)"Popular spaces portlet preferences settings removed successfully");
                this.portletUpdated = true;
            }
            if (transactionStarted && entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().commit();
                entityManager.flush();
            }
        }
        catch (Exception e) {
            if (transactionStarted && entityManager.getTransaction().isActive() && entityManager.getTransaction().getRollbackOnly()) {
                entityManager.getTransaction().rollback();
            }
        }
        finally {
            RequestLifeCycle.end();
        }
        LOG.info("End upgrade of Popular spaces portlet. It took {} ms", new Object[]{System.currentTimeMillis() - startupTime});
    }

    public boolean isPortletUpdated() {
        return this.portletUpdated;
    }
}

