/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UsersLastLoginTimeMigration
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(UsersLastLoginTimeMigration.class);
    private static final int MAX_RESULT = 200;
    private EntityManagerService entityManagerService;
    String sqlQuery = "SELECT REMOTE_ID FROM SOC_IDENTITIES WHERE ENABLED=true AND PROVIDER_ID='organization' AND IDENTITY_ID NOT IN (   SELECT si.IDENTITY_ID FROM SOC_IDENTITIES si   INNER JOIN SOC_IDENTITY_PROPERTIES sip ON si.IDENTITY_ID = sip.IDENTITY_ID   WHERE sip.NAME = 'lastLoginTime') AND REMOTE_ID IN (   SELECT llt.NAME FROM (     SELECT jbid_io.NAME,jbid_io.ID,jbid_io_attr_text_values.ATTR_VALUE from jbid_io     INNER JOIN jbid_io_attr ON jbid_io.ID =  jbid_io_attr.IDENTITY_OBJECT_ID     INNER JOIN jbid_io_attr_text_values ON jbid_io_attr.ATTRIBUTE_ID = jbid_io_attr_text_values.TEXT_ATTR_VALUE_ID     AND jbid_io_attr.name = 'lastLoginTime'   ) llt   INNER JOIN (     SELECT jbid_io.NAME,jbid_io.ID,jbid_io_attr_text_values.ATTR_VALUE from jbid_io     INNER JOIN jbid_io_attr ON jbid_io.ID =  jbid_io_attr.IDENTITY_OBJECT_ID      INNER JOIN jbid_io_attr_text_values ON jbid_io_attr.ATTRIBUTE_ID = jbid_io_attr_text_values.TEXT_ATTR_VALUE_ID     AND jbid_io_attr.name = 'createdDate'   ) AS cdt   ON llt.ID=cdt.ID   WHERE llt.ATTR_VALUE!=cdt.ATTR_VALUE) ";
    String countQuery = "SELECT COUNT(REMOTE_ID) FROM SOC_IDENTITIES WHERE ENABLED=true AND PROVIDER_ID='organization' AND IDENTITY_ID NOT IN (   SELECT si.IDENTITY_ID FROM SOC_IDENTITIES si   INNER JOIN SOC_IDENTITY_PROPERTIES sip ON si.IDENTITY_ID = sip.IDENTITY_ID   WHERE sip.NAME = 'lastLoginTime') AND REMOTE_ID IN (   SELECT llt.NAME FROM (     SELECT jbid_io.NAME,jbid_io.ID,jbid_io_attr_text_values.ATTR_VALUE from jbid_io     INNER JOIN jbid_io_attr ON jbid_io.ID =  jbid_io_attr.IDENTITY_OBJECT_ID      INNER JOIN jbid_io_attr_text_values ON jbid_io_attr.ATTRIBUTE_ID = jbid_io_attr_text_values.TEXT_ATTR_VALUE_ID     AND jbid_io_attr.name = 'lastLoginTime'   ) llt   INNER JOIN (     SELECT jbid_io.NAME,jbid_io.ID,jbid_io_attr_text_values.ATTR_VALUE from jbid_io     INNER JOIN jbid_io_attr ON jbid_io.ID =  jbid_io_attr.IDENTITY_OBJECT_ID      INNER JOIN jbid_io_attr_text_values ON jbid_io_attr.ATTRIBUTE_ID = jbid_io_attr_text_values.TEXT_ATTR_VALUE_ID     AND jbid_io_attr.name = 'createdDate'   ) AS cdt   ON llt.ID=cdt.ID   WHERE llt.ATTR_VALUE!=cdt.ATTR_VALUE) ";
    String getUserLastLoginTimeQueryString = "SELECT jbid_io_attr_text_values.ATTR_VALUE FROM jbid_io INNER JOIN jbid_io_attr ON jbid_io.ID = jbid_io_attr.IDENTITY_OBJECT_ID INNER JOIN jbid_io_attr_text_values ON jbid_io_attr.ATTRIBUTE_ID = jbid_io_attr_text_values.TEXT_ATTR_VALUE_ID WHERE jbid_io_attr.name = 'lastLoginTime' AND jbid_io.NAME=:username";
    String getIdentityIdQueryString = "SELECT si.IDENTITY_ID FROM SOC_IDENTITIES si WHERE si.REMOTE_ID=:username";
    String insertProfileLastLoginTimeQueryString = "INSERT INTO SOC_IDENTITY_PROPERTIES VALUES (:identityId, 'lastLoginTime',:lastLoginTime)";

    public UsersLastLoginTimeMigration(EntityManagerService entityManagerService, InitParams initParams) {
        super(initParams);
        this.entityManagerService = entityManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"Start upgrade process to add lastLoginTime in user profile");
        long startupTime = System.currentTimeMillis();
        try {
            long totalSize;
            int totalItemsFixed = 0;
            int offset = 0;
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            EntityManager entityManager = this.entityManagerService.getEntityManager();
            try {
                LOG.debug("Execute count query {}", new Object[]{this.countQuery});
                Query countNativeQuery = entityManager.createNativeQuery(this.countQuery);
                totalSize = ((Number)countNativeQuery.getSingleResult()).intValue();
            }
            finally {
                RequestLifeCycle.end();
            }
            LOG.info((Object)("Number of users to fix : " + totalSize));
            do {
                RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
                ArrayList<Object> remoteIds = new ArrayList();
                try {
                    long startTimeForBatch = System.currentTimeMillis();
                    Query sqlNativeQuery = entityManager.createNativeQuery(this.sqlQuery);
                    sqlNativeQuery.setMaxResults(200);
                    sqlNativeQuery.setFirstResult(offset);
                    remoteIds = sqlNativeQuery.getResultList();
                    LOG.debug("Query to get users executed in {}ms", new Object[]{System.currentTimeMillis() - startTimeForBatch});
                    int updatedUsers = this.updateLastLoginTime(remoteIds);
                    offset += remoteIds.size() - updatedUsers;
                    LOG.info("Progession : {} users fixed on {} total users. It tooks {}ms", new Object[]{totalItemsFixed += remoteIds.size(), totalSize, System.currentTimeMillis() - startTimeForBatch});
                }
                finally {
                    RequestLifeCycle.end();
                }
            } while ((long)totalItemsFixed < totalSize);
            LOG.info("Upgrade of {} / {} proceeded successfully.", new Object[]{totalItemsFixed, totalSize});
        }
        catch (Exception e) {
            LOG.error((Object)"Error processUpgrade data-upgrade-users", (Throwable)e);
            throw new IllegalStateException("Upgrade failed when upgrade-users");
        }
        LOG.info("End process to add lastLoginTime in user profile. It took {} ms.", new Object[]{System.currentTimeMillis() - startupTime});
    }

    public int updateLastLoginTime(List<Object> remoteIds) throws Exception {
        int numberOfModifiedItems = 0;
        int numberOfNotModifiedItems = 0;
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        for (Object remoteId : remoteIds) {
            try {
                long startTime = System.currentTimeMillis();
                String username = (String)remoteId;
                Query getIdentityIdQuery = entityManager.createNativeQuery(this.getIdentityIdQueryString);
                getIdentityIdQuery.setParameter("username", (Object)username);
                List resultListId = getIdentityIdQuery.getResultList();
                if (resultListId.isEmpty()) {
                    ++numberOfNotModifiedItems;
                } else {
                    Long identityId = Long.parseLong(resultListId.get(0).toString());
                    Query getUserLastLoginTimeQuery = entityManager.createNativeQuery(this.getUserLastLoginTimeQueryString);
                    getUserLastLoginTimeQuery.setParameter("username", (Object)username);
                    Long lastLoginTime = Long.parseLong(getUserLastLoginTimeQuery.getResultList().get(0).toString());
                    entityManager.getTransaction().begin();
                    Date lastLoginDate = new Date(lastLoginTime);
                    Query insertProfileLastLoginTimeQuery = entityManager.createNativeQuery(this.insertProfileLastLoginTimeQueryString);
                    insertProfileLastLoginTimeQuery.setParameter("identityId", (Object)identityId);
                    insertProfileLastLoginTimeQuery.setParameter("lastLoginTime", (Object)String.valueOf(lastLoginDate));
                    insertProfileLastLoginTimeQuery.executeUpdate();
                    entityManager.getTransaction().commit();
                    IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
                    indexingService.reindex("profile", identityId.toString());
                    ++numberOfModifiedItems;
                }
                LOG.debug("User {} fixed in {}ms, {}/{} in current batch.", new Object[]{username, System.currentTimeMillis() - startTime, numberOfModifiedItems + numberOfNotModifiedItems, remoteIds.size()});
            }
            catch (Exception e) {
                LOG.error("Error when updating user {}", new Object[]{remoteId.toString(), e});
                entityManager.getTransaction().rollback();
                throw new RuntimeException(e);
            }
        }
        return numberOfModifiedItems;
    }
}

