/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.upgrade;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AppRegistryUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(AppRegistryUpgradePlugin.class);
    private final PortalContainer container;
    private final EntityManagerService entityManagerService;
    private int pagesUpdatedCount;
    private static final String OLD_CONTENT_ID = "old.content.id";
    private static final String NEW_DESCRIPTION = "new.description";
    private static final String NEW_DISPLAY_NAME = "new.display.name";
    private static final String NEW_APP_NAME = "new.app.name";
    private static final String NEW_CONTENT_ID = "new.content.id";
    private String oldContentId;
    private String newDisplayName;
    private String newAppName;
    private String newContentId;
    private String newDescription;

    public AppRegistryUpgradePlugin(PortalContainer container, EntityManagerService entityManagerService, InitParams initParams) {
        super(initParams);
        this.container = container;
        this.entityManagerService = entityManagerService;
        if (initParams.containsKey((Object)OLD_CONTENT_ID)) {
            this.oldContentId = initParams.getValueParam(OLD_CONTENT_ID).getValue();
        }
        if (initParams.containsKey((Object)NEW_DISPLAY_NAME)) {
            this.newDisplayName = initParams.getValueParam(NEW_DISPLAY_NAME).getValue();
        }
        if (initParams.containsKey((Object)NEW_DESCRIPTION)) {
            this.newDescription = initParams.getValueParam(NEW_DESCRIPTION).getValue();
        }
        if (initParams.containsKey((Object)NEW_APP_NAME)) {
            this.newAppName = initParams.getValueParam(NEW_APP_NAME).getValue();
        }
        if (initParams.containsKey((Object)NEW_CONTENT_ID)) {
            this.newContentId = initParams.getValueParam(NEW_CONTENT_ID).getValue();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (StringUtils.isEmpty((CharSequence)this.oldContentId) || StringUtils.isEmpty((CharSequence)this.newAppName) || StringUtils.isEmpty((CharSequence)this.newDisplayName) || StringUtils.isEmpty((CharSequence)this.newDescription) || StringUtils.isEmpty((CharSequence)this.newContentId)) {
            LOG.error((Object)"Couldn't process upgrade, all parameters are mandatory");
            return;
        }
        long startupTime = System.currentTimeMillis();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        boolean transactionStarted = false;
        LOG.info("Start upgrade of app with content id {} in registry to use {}", new Object[]{this.oldContentId, this.newContentId});
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        try {
            if (!entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().begin();
                transactionStarted = true;
            }
            String sqlString = "UPDATE PORTAL_APPLICATIONS SET DISPLAY_NAME = '" + this.newDisplayName + "' , DESCRIPTION = '" + this.newDescription + "' , APP_NAME = '" + this.newAppName + "', CONTENT_ID = '" + this.newContentId + "' WHERE CONTENT_ID = '" + this.oldContentId + "'  AND ID > 0;";
            Query nativeQuery = entityManager.createNativeQuery(sqlString);
            this.pagesUpdatedCount = nativeQuery.executeUpdate();
            LOG.info("End upgrade of '{}' apps with content id {} in registry to use {}. It took {} ms", new Object[]{this.oldContentId, this.newContentId, this.pagesUpdatedCount, System.currentTimeMillis() - startupTime});
            if (transactionStarted && entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().commit();
                entityManager.clear();
                entityManager.flush();
            }
        }
        catch (Exception e) {
            if (transactionStarted && entityManager.getTransaction().isActive() && entityManager.getTransaction().getRollbackOnly()) {
                entityManager.getTransaction().rollback();
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public int getPagesUpdatedCount() {
        return this.pagesUpdatedCount;
    }
}

