/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SiteExplorerTemplateUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger((String)SiteExplorerTemplateUpgradePlugin.class.getName());
    private NodeHierarchyCreator nodeHierarchyCreator;
    private DMSConfiguration dmsConfiguration;
    private RepositoryService repositoryService;
    private ManageViewService manageViewService;
    private int siteExplorerTemplatesUpdatedCount;

    public SiteExplorerTemplateUpgradePlugin(InitParams initParams, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repoService, DMSConfiguration dmsConfiguration, ManageViewService manageViewService) {
        super(initParams);
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.repositoryService = repoService;
        this.dmsConfiguration = dmsConfiguration;
        this.manageViewService = manageViewService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        log.info((Object)"Start upgrade of site explorer templates");
        String unchangedViews = System.getProperty("unchanged-site-explorer-templates");
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((CharSequence)unchangedViews)) {
            unchangedViews = "";
        }
        try {
            HashSet<String> unchangedViewSet = new HashSet<String>();
            this.manageViewService.init();
            Set configuredTemplates = this.manageViewService.getConfiguredTemplates();
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            for (String unchangedView : unchangedViews.split(",")) {
                unchangedViewSet.add(unchangedView.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration.getConfig();
            Session session = sessionProvider.getSession(dmsRepoConfig.getSystemWorkspace(), this.repositoryService.getCurrentRepository());
            String ecmExplorerViewNodePath = this.nodeHierarchyCreator.getJcrPath("ecmExplorerTemplates");
            Node ecmExplorerViewNode = (Node)session.getItem(ecmExplorerViewNodePath);
            NodeIterator iter = ecmExplorerViewNode.getNodes();
            while (iter.hasNext()) {
                Node viewNode = iter.nextNode();
                if (unchangedViewSet.contains(viewNode.getName()) || !configuredTemplates.contains(viewNode.getName())) continue;
                removedNodes.add(viewNode);
            }
            for (Node removedNode : removedNodes) {
                try {
                    removedNode.remove();
                    ecmExplorerViewNode.save();
                    ++this.siteExplorerTemplatesUpdatedCount;
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) continue;
                    log.error((Object)("Error in " + ((Object)((Object)this)).getClass().getName() + ": Can not remove old query node: " + removedNode.getPath()));
                }
            }
            this.manageViewService.init();
            log.info("End upgrade of '{}' site explorer templates. It took {} ms", new Object[]{this.siteExplorerTemplatesUpdatedCount, System.currentTimeMillis() - startupTime});
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"An unexpected error occurs when migrating Site Explorer views:", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public int getSiteExplorerTemplatesUpdatedCount() {
        return this.siteExplorerTemplatesUpdatedCount;
    }
}

