/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortalPagesProfilesMigration
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(PortalPagesProfilesMigration.class);
    private static final String OLD_PAGES_PROFILES = "old.pages.profiles";
    private static final String NEW_PAGES_PROFILES = "new.pages.profiles";
    private PortalContainer container;
    private EntityManagerService entityManagerService;
    private Map<String, String> pagesProfiles = new HashMap<String, String>();
    private int pagesUpdatedCount;

    public PortalPagesProfilesMigration(PortalContainer container, EntityManagerService entityManagerService, InitParams initParams) {
        super(initParams);
        this.container = container;
        this.entityManagerService = entityManagerService;
        if (initParams.containsKey((Object)OLD_PAGES_PROFILES) && initParams.containsKey((Object)NEW_PAGES_PROFILES)) {
            this.pagesProfiles.put(initParams.getValueParam(OLD_PAGES_PROFILES).getValue(), initParams.getValueParam(NEW_PAGES_PROFILES).getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String s, String s1) {
        if (this.pagesProfiles.isEmpty()) {
            LOG.error("Couldn't process upgrade, the parameter '{}' is mandatory", new Object[]{OLD_PAGES_PROFILES});
            return;
        }
        long startupTime = System.currentTimeMillis();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        boolean transactionStarted = false;
        Set<Map.Entry<String, String>> pageProfilesEntrySet = this.pagesProfiles.entrySet();
        for (Map.Entry<String, String> profiles : pageProfilesEntrySet) {
            String oldPagesProfiles = profiles.getKey().trim();
            String newPagesProfiles = profiles.getValue().trim();
            LOG.info("Start upgrade of pages with profiles '{}' to use profiles '{}'", new Object[]{oldPagesProfiles, newPagesProfiles});
            RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
            EntityManager entityManager = this.entityManagerService.getEntityManager();
            try {
                if (!entityManager.getTransaction().isActive()) {
                    entityManager.getTransaction().begin();
                    transactionStarted = true;
                }
                String sqlString = "UPDATE PORTAL_PAGES  SET PROFILES = '" + newPagesProfiles + "' WHERE PROFILES = '" + oldPagesProfiles + "' AND ID > 0;";
                Query nativeQuery = entityManager.createNativeQuery(sqlString);
                this.pagesUpdatedCount = nativeQuery.executeUpdate();
                LOG.info("End upgrade of '{}' pages with profiles '{}' to use profiles '{}'. It took {} ms", new Object[]{this.pagesUpdatedCount, oldPagesProfiles, newPagesProfiles, System.currentTimeMillis() - startupTime});
                if (!transactionStarted || !entityManager.getTransaction().isActive()) continue;
                entityManager.getTransaction().commit();
                entityManager.flush();
            }
            catch (Exception e) {
                if (!transactionStarted || !entityManager.getTransaction().isActive() || !entityManager.getTransaction().getRollbackOnly()) continue;
                entityManager.getTransaction().rollback();
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public int getPagesUpdatedCount() {
        return this.pagesUpdatedCount;
    }
}

