/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.attachments.model.AttachmentContextEntity;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ProcessesDocumentsUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getExoLogger(ProcessesDocumentsUpgradePlugin.class);
    private RepositoryService repositoryService;
    private OnlyofficeEditorService onlyofficeEditorService;
    private EntityManagerService entityManagerService;
    private UserACL userACL;

    public ProcessesDocumentsUpgradePlugin(EntityManagerService entityManagerService, RepositoryService repositoryService, OnlyofficeEditorService onlyofficeEditorService, UserACL userACL, InitParams initParams) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.onlyofficeEditorService = onlyofficeEditorService;
        this.userACL = userACL;
        this.entityManagerService = entityManagerService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        log.info((Object)"Start Processes documents upgrade");
        ArrayList<String> errorPath = new ArrayList<String>();
        try {
            List<AttachmentContextEntity> attachments = this.getAllAttachments();
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession("collaboration", this.repositoryService.getDefaultRepository());
            HashMap<String, String> attachmentIdReplacement = new HashMap<String, String>();
            long total = attachments.size();
            int currentIndex = 0;
            log.info("Processes documents upgrade Select query executed in {} ms, {} elements to check", new Object[]{System.currentTimeMillis() - startupTime, total});
            for (AttachmentContextEntity attachment : attachments) {
                if (!attachmentIdReplacement.containsKey(attachment.getAttachmentId())) {
                    try {
                        Node file = session.getNodeByUUID(attachment.getAttachmentId());
                        log.debug("Proceed node {}", new Object[]{file.getPath()});
                        if (!file.getPath().startsWith("/Trash") && file.isNodeType("nt:file") && (file.getName().endsWith(".docxf") || file.getName().endsWith(".oform"))) {
                            String owner = this.userACL.getSuperUser();
                            byte[] convertedContent = this.onlyofficeEditorService.convertNodeContentToPdf(file, owner);
                            if (convertedContent != null) {
                                String newFileUuid = this.createNewFile(convertedContent, file);
                                attachmentIdReplacement.put(attachment.getAttachmentId(), newFileUuid);
                            } else {
                                errorPath.add(file.getPath());
                            }
                        }
                    }
                    catch (ItemNotFoundException e) {
                        log.warn("Node with uuid {} not exists in collaboration workspace", new Object[]{attachment.getAttachmentId()});
                    }
                    catch (UnsupportedRepositoryOperationException e) {
                        log.warn("Node with uuid {} cannot be read (must be a symlink, ignore it)", new Object[]{attachment.getAttachmentId()});
                    }
                    catch (ItemExistsException e) {
                        log.warn("Node with uuid {} already converted", new Object[]{attachment.getAttachmentId()});
                    }
                }
                if (++currentIndex % 100 != 0) continue;
                log.info("{}/{} elements processed", new Object[]{currentIndex, total});
            }
            log.info("{} documents converted. Start step 2 to update attachment table", new Object[]{attachmentIdReplacement.size()});
            attachmentIdReplacement.forEach(this::updateAttachementUuId);
            if (!errorPath.isEmpty()) {
                throw new IllegalStateException(String.format("End converting documents. %s documents converted. There are %s errors for files %s. It took %s ms.", attachmentIdReplacement.size(), errorPath.size(), errorPath, System.currentTimeMillis() - startupTime));
            }
            log.info("End Processes documents upgrade, execution time={}ms, {} elements processed, {} converted", new Object[]{System.currentTimeMillis() - startupTime, total, attachmentIdReplacement.size()});
        }
        catch (Exception e) {
            log.error((Object)"Error when updating document for OO 8", (Throwable)e);
            throw new IllegalStateException("Upgrade Plugin not executed");
        }
    }

    private String createNewFile(byte[] convertedContent, Node file) throws Exception {
        log.debug("File converted in a byte array of lenght={}", new Object[]{convertedContent.length});
        Node newNode = this.duplicateItem(file, file.getParent(), file.getParent());
        Node jcrContent = newNode.getNode("jcr:content");
        ByteArrayInputStream stream = new ByteArrayInputStream(convertedContent);
        jcrContent.setProperty("jcr:mimeType", "application/pdf");
        jcrContent.setProperty("jcr:data", (InputStream)stream);
        file.getParent().save();
        return newNode.getUUID();
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AttachmentContextEntity> getEntityAttached(String uuid) {
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        ArrayList<AttachmentContextEntity> results = new ArrayList();
        try {
            String sqlString = "SELECT * FROM EXO_ATTACHMENTS_CONTEXT WHERE ATTACHMENT_ID = '" + uuid + "'";
            Query query = entityManager.createNativeQuery(sqlString, AttachmentContextEntity.class);
            results = query.getResultList();
        }
        catch (Exception e) {
            log.error("Error when reading attachment entity for file with id={}", new Object[]{uuid, e});
        }
        finally {
            RequestLifeCycle.end();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AttachmentContextEntity> getAllAttachments() {
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        ArrayList<AttachmentContextEntity> results = new ArrayList();
        try {
            String sqlString = "SELECT * FROM EXO_ATTACHMENTS_CONTEXT";
            Query query = entityManager.createNativeQuery(sqlString, AttachmentContextEntity.class);
            results = query.getResultList();
        }
        catch (Exception e) {
            log.error((Object)"Error when reading all attachments entity", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAttachementUuId(String oldUUID, String newUUID) {
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        try {
            entityManager.getTransaction().begin();
            String sqlString = "UPDATE EXO_ATTACHMENTS_CONTEXT SET ATTACHMENT_ID = '" + newUUID + "' WHERE ATTACHMENT_ID='" + oldUUID + "'";
            Query query = entityManager.createNativeQuery(sqlString, AttachmentContextEntity.class);
            query.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            log.error("Error when updating attachment for attachmentContext with uuid={}", new Object[]{oldUUID, e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private Node duplicateItem(Node oldNode, Node destinationNode, Node parentNode) throws Exception {
        String name = oldNode.getName();
        Object title = oldNode.getProperty("exo:title").getString();
        if (((NodeImpl)destinationNode).getIdentifier().equals(((NodeImpl)parentNode).getIdentifier())) {
            name = name.replace(".docxf", ".pdf");
            name = name.replace(".oform", ".pdf");
            title = ((String)title).replace(".docxf", ".pdf");
            title = ((String)title).replace(".oform", ".pdf");
            Object newName = name;
            int i = 0;
            while (destinationNode.hasNode((String)newName)) {
                newName = name + " (" + ++i + ")";
            }
            name = ((String)newName).toLowerCase();
            if (i > 0) {
                title = (String)title + " (" + i + ")";
            }
        }
        name = URLDecoder.decode(name, "UTF-8");
        Node newNode = destinationNode.addNode(name, oldNode.getPrimaryNodeType().getName());
        this.addProperties(oldNode, newNode, (String)title);
        return newNode;
    }

    private void addProperties(Node oldNode, Node newNode, String title) throws RepositoryException {
        if (oldNode.isNodeType("mix:versionable") && !newNode.isNodeType("mix:versionable")) {
            newNode.addMixin("mix:versionable");
        }
        if (oldNode.isNodeType("mix:referenceable") && !newNode.isNodeType("mix:referenceable")) {
            newNode.addMixin("mix:referenceable");
        }
        if (oldNode.isNodeType("mix:commentable") && !newNode.isNodeType("mix:commentable")) {
            newNode.addMixin("mix:commentable");
        }
        if (oldNode.isNodeType("mix:votable") && !newNode.isNodeType("mix:votable")) {
            newNode.addMixin("mix:votable");
        }
        if (oldNode.isNodeType("mix:i18n") && !newNode.isNodeType("mix:i18n")) {
            newNode.addMixin("mix:i18n");
        }
        newNode.setProperty("exo:title", title);
        newNode.setProperty("exo:lastModifier", oldNode.getProperty("exo:lastModifier").getString());
        newNode.setProperty("exo:dateCreated", oldNode.getProperty("exo:dateCreated").getDate());
        newNode.setProperty("exo:dateModified", oldNode.getProperty("exo:dateModified").getDate());
        newNode.setProperty("exo:lastModifiedDate", oldNode.getProperty("exo:lastModifiedDate").getDate());
        if (oldNode.hasNode("jcr:content")) {
            Node resourceNode = newNode.addNode("jcr:content", "nt:resource");
            resourceNode.setProperty("jcr:data", oldNode.getNode("jcr:content").getProperty("jcr:data").getStream());
            resourceNode.setProperty("jcr:mimeType", oldNode.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            resourceNode.setProperty("jcr:lastModified", oldNode.getNode("jcr:content").getProperty("jcr:lastModified").getDate());
            resourceNode.setProperty("exo:dateModified", oldNode.getNode("jcr:content").getProperty("exo:dateModified").getDate());
            resourceNode.setProperty("exo:dateCreated", oldNode.getNode("jcr:content").getProperty("exo:dateCreated").getDate());
        }
    }
}

