/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AddCSSClassToPage
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(AddCSSClassToPage.class);
    private final PageStorage pageStorage;
    private String cssClasses;
    private String siteName;
    private String pageName;
    private String containerId;

    public AddCSSClassToPage(PageStorage pageStorage, InitParams initParams) {
        super(initParams);
        String pageNameParam;
        String cssClassesParam;
        String containerIdParam;
        this.pageStorage = pageStorage;
        String siteNameParam = "site-name";
        if (initParams.containsKey((Object)siteNameParam) && !initParams.getValueParam(siteNameParam).getValue().isBlank()) {
            this.siteName = initParams.getValueParam(siteNameParam).getValue();
        }
        if (initParams.containsKey((Object)(containerIdParam = "container-id")) && !initParams.getValueParam(containerIdParam).getValue().isBlank()) {
            this.containerId = initParams.getValueParam(containerIdParam).getValue();
        }
        if (initParams.containsKey((Object)(cssClassesParam = "css-classes")) && !initParams.getValueParam(cssClassesParam).getValue().isBlank()) {
            this.cssClasses = initParams.getValueParam(cssClassesParam).getValue();
        }
        if (initParams.containsKey((Object)(pageNameParam = "page-name")) && !initParams.getValueParam(pageNameParam).getValue().isBlank()) {
            this.pageName = initParams.getValueParam(pageNameParam).getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info("Start upgrade : adding CSS class {} to {} page", new Object[]{this.cssClasses, this.pageName});
        if (StringUtils.isBlank((CharSequence)this.siteName) || StringUtils.isBlank((CharSequence)this.pageName) || StringUtils.isBlank((CharSequence)this.containerId) || StringUtils.isBlank((CharSequence)this.cssClasses)) {
            LOG.warn((Object)"upgrade canceled : missing required parameters");
            return;
        }
        long startupTime = System.currentTimeMillis();
        PortalContainer portalContainer = PortalContainer.getInstance();
        RequestLifeCycle.begin((ExoContainer)portalContainer);
        try {
            Page page = this.pageStorage.getPage(new PageKey(SiteType.PORTAL.getName(), this.siteName, this.pageName));
            for (ModelObject child : page.getChildren()) {
                Container container;
                if (!(child instanceof Container) || !this.containerId.equals((container = (Container)child).getId())) continue;
                container.setCssClass(this.cssClasses);
            }
            this.pageStorage.save(page.build());
        }
        catch (Exception e) {
            try {
                LOG.error("Upgrade error : Failed to update the page {}", new Object[]{this.pageName, e});
            }
            catch (Throwable throwable) {
                LOG.info("End upgrade : adding CSS class {} to {} page. It took {} ms", new Object[]{this.cssClasses, this.pageName, System.currentTimeMillis() - startupTime});
                throw throwable;
            }
            LOG.info("End upgrade : adding CSS class {} to {} page. It took {} ms", new Object[]{this.cssClasses, this.pageName, System.currentTimeMillis() - startupTime});
        }
        LOG.info("End upgrade : adding CSS class {} to {} page. It took {} ms", new Object[]{this.cssClasses, this.pageName, System.currentTimeMillis() - startupTime});
    }
}

