/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.ArrayList;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.migration.PopularSpacesRemovePreferences;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageState;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/config/conf/configuration.xml")})
public class PopularSpacesRemovePreferencesTest
extends AbstractKernelTest {
    private static final String SITE_TYPE = PortalConfig.PORTAL_TYPE;
    private static final String SITE_NAME = "testSite";
    protected PortalContainer container;
    protected PageService pageService;
    protected DataStorage dataStorage;
    protected EntityManagerService entityManagerService;
    protected Page testPage;

    public PopularSpacesRemovePreferencesTest() {
        this.setForceContainerReload(true);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.container = this.getContainer();
        this.pageService = (PageService)this.container.getComponentInstanceOfType(PageService.class);
        this.dataStorage = (DataStorage)this.container.getComponentInstanceOfType(DataStorage.class);
        this.entityManagerService = (EntityManagerService)this.container.getComponentInstanceOfType(EntityManagerService.class);
        this.begin();
    }

    @Test
    public void testUpgradePopularSpacesPortlet() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        RequestLifeCycle.begin((ExoContainer)this.container);
        PortalConfig portalConfig = this.dataStorage.getPortalConfig(SITE_TYPE, SITE_NAME);
        if (portalConfig == null) {
            portalConfig = new PortalConfig(SITE_TYPE, SITE_NAME);
            this.dataStorage.create(portalConfig);
        }
        this.testPage = this.createPage("Popular spaces", "gamification-portlets/PopularSpaces");
        PopularSpacesRemovePreferences preferences = new PopularSpacesRemovePreferences(this.entityManagerService, initParams);
        PopularSpacesRemovePreferencesTest.assertFalse((boolean)preferences.isPortletUpdated());
        preferences.processUpgrade(null, null);
        PopularSpacesRemovePreferencesTest.assertTrue((boolean)preferences.isPortletUpdated());
    }

    @After
    public void tearDown() throws Exception {
        this.pageService.destroyPage(this.testPage.getPageKey());
        this.end();
    }

    private Page createPage(String pageName, String contentId) throws Exception {
        Page page = new Page(SITE_TYPE, SITE_NAME, pageName);
        page.setAccessPermissions(new String[]{"Everyone"});
        ArrayList<Application> children = new ArrayList<Application>();
        page.setChildren(children);
        Application app = Application.createPortletApplication();
        children.add(app);
        app.setState((ApplicationState)new TransientApplicationState(contentId, (Object)"test custom preferences"));
        app.setTheme("theme");
        app.setTitle("title");
        app.setAccessPermissions(new String[]{"Everyone"});
        app.setStorageName("storage");
        PageState pageState = Utils.toPageState((Page)page);
        this.pageService.savePage(new PageContext(page.getPageKey(), pageState));
        this.dataStorage.save(page);
        return page;
    }
}

