/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Query;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.migration.SpaceApplicationMigration;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceApplicationMigrationTest {
    @Mock
    private SpaceService spaceService;
    @Mock
    private EntityManagerService entityManagerService;
    @Mock
    private SettingService settingService;
    @Mock
    private PortalContainer rootContainer;
    @Mock
    private EntityManager entityManager;
    private SpaceApplicationMigration spaceApplicationMigration;
    private static final MockedStatic<PortalContainer> portalContainerMockedStatic = Mockito.mockStatic(PortalContainer.class);

    @Before
    public void setUp() {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        ValueParam oldAppNameParam = new ValueParam();
        oldAppNameParam.setName("old.app.name");
        oldAppNameParam.setValue("oldAppName");
        ValueParam oldAppIdParam = new ValueParam();
        oldAppIdParam.setName("old.app.id");
        oldAppIdParam.setValue("oldAppId");
        ValueParam newAppIdParam = new ValueParam();
        newAppIdParam.setName("new.app.id");
        newAppIdParam.setValue("newAppId");
        initParams.addParam((Object)oldAppNameParam);
        initParams.addParam((Object)oldAppIdParam);
        initParams.addParam((Object)newAppIdParam);
        this.spaceApplicationMigration = new SpaceApplicationMigration(this.spaceService, this.entityManagerService, this.settingService, initParams);
    }

    @After
    public void tearDown() {
        if (!portalContainerMockedStatic.isClosed()) {
            portalContainerMockedStatic.close();
        }
    }

    @Test
    public void testProcessUpgrade() throws Exception {
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)space.getApp()).thenReturn((Object)"app");
        Space[] spacesArray = new Space[]{space};
        ListAccess listAccessMock = (ListAccess)Mockito.mock(ListAccess.class);
        portalContainerMockedStatic.when(PortalContainer::getInstance).thenReturn((Object)this.rootContainer);
        Mockito.when((Object)this.spaceService.getAllSpacesByFilter((SpaceFilter)ArgumentMatchers.any(SpaceFilter.class))).thenReturn((Object)listAccessMock);
        Mockito.when((Object)((Space[])listAccessMock.load(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt()))).thenReturn((Object)spacesArray);
        Mockito.when((Object)listAccessMock.getSize()).thenReturn((Object)spacesArray.length);
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"groupId");
        Mockito.when((Object)space.getId()).thenReturn((Object)"spaceId");
        Mockito.when((Object)space.getDisplayName()).thenReturn((Object)"Space Display Name");
        Query queryMock = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)this.entityManagerService.getEntityManager()).thenReturn((Object)this.entityManager);
        EntityTransaction transaction = (EntityTransaction)Mockito.mock(EntityTransaction.class);
        Mockito.when((Object)this.entityManager.getTransaction()).thenReturn((Object)transaction);
        Mockito.when((Object)transaction.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.entityManager.createNativeQuery(ArgumentMatchers.anyString())).thenReturn((Object)queryMock);
        this.spaceApplicationMigration.processUpgrade("newVersion", "previousGroupVersion");
        ((EntityManager)Mockito.verify((Object)this.entityManager, (VerificationMode)Mockito.times((int)1))).createNativeQuery((String)ArgumentMatchers.eq((Object)"DELETE FROM PORTAL_PAGES WHERE SITE_ID IN (SELECT ID FROM PORTAL_SITES WHERE NAME ='groupId') AND NAME='oldAppId'"));
        ((EntityManager)Mockito.verify((Object)this.entityManager, (VerificationMode)Mockito.times((int)1))).createNativeQuery((String)ArgumentMatchers.eq((Object)"DELETE FROM SOC_APPS WHERE APP_ID='oldAppId' AND SPACE_ID= 'spaceId'"));
        ((Query)Mockito.verify((Object)queryMock, (VerificationMode)Mockito.times((int)2))).executeUpdate();
        ((SpaceService)Mockito.verify((Object)this.spaceService, (VerificationMode)Mockito.times((int)1))).installApplication((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)"newAppId"));
        ((SpaceService)Mockito.verify((Object)this.spaceService, (VerificationMode)Mockito.times((int)1))).activateApplication((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)"newAppId"));
    }

    @Test
    public void testAfterUpgrade() {
        this.spaceApplicationMigration.afterUpgrade();
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"SpaceApplicationMigrationEnded"), (SettingValue)ArgumentMatchers.any());
    }
}

