/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.description;

import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.description.CacheKey;
import org.exoplatform.portal.mop.description.CacheValue;
import org.exoplatform.portal.mop.i18n.I18NAdapter;
import org.exoplatform.portal.mop.i18n.Resolution;
import org.exoplatform.portal.pom.config.POMSession;
import org.gatein.mop.api.workspace.WorkspaceObject;

abstract class DataCache {
    DataCache() {
    }

    protected abstract void removeState(CacheKey var1);

    protected abstract State getState(POMSession var1, CacheKey var2);

    protected final CacheValue getValue(POMSession session, CacheKey key) {
        WorkspaceObject obj = session.findObjectById(key.id);
        I18NAdapter able = (I18NAdapter)obj.adapt(I18NAdapter.class);
        Resolution<Described> res = able.resolveI18NMixin(Described.class, key.locale);
        if (res != null) {
            State state = res.getMixin().getState();
            if (key.locale.equals(res.getLocale())) {
                CacheValue foo = new CacheValue(state);
                this.putValue(key, foo);
                return foo;
            }
            CacheValue origin = new CacheValue(state);
            CacheKey originKey = new CacheKey(res.getLocale(), key.id);
            this.putValue(originKey, origin);
            CacheValue foo = new CacheValue(originKey, origin.serial, state);
            this.putValue(key, foo);
            return foo;
        }
        return CacheValue.NULL_VALUE;
    }

    protected abstract void putValue(CacheKey var1, CacheValue var2);
}

