/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.io.Serializable;
import java.util.Collection;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.DataCache;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class ExoDataCache
extends DataCache {
    private static final String CACHE_NAME = "portal.NavigationService";
    protected ExoCache<Serializable, Serializable> cache;
    protected FutureExoCache<Serializable, Serializable, POMSession> objects;
    private Loader<Serializable, Serializable, POMSession> navigationLoader = new Loader<Serializable, Serializable, POMSession>(){

        public Serializable retrieve(POMSession session, Serializable key) throws Exception {
            if (key instanceof SiteKey) {
                return ExoDataCache.this.loadNavigation(session, (SiteKey)key);
            }
            return ExoDataCache.this.loadNode(session, (String)((Object)key));
        }
    };

    public ExoDataCache(CacheService cacheService) {
        this.cache = cacheService.getCacheInstance(CACHE_NAME);
        this.objects = new FutureExoCache(this.navigationLoader, this.cache);
    }

    @Override
    protected void removeNodes(Collection<String> keys) {
        for (String key : keys) {
            this.cache.remove((Serializable)((Object)key));
        }
    }

    @Override
    protected NodeData getNode(POMSession session, String key) {
        return (NodeData)this.objects.get((Object)session, (Object)key);
    }

    @Override
    protected void removeNavigation(SiteKey key) {
        this.cache.remove((Serializable)key);
    }

    @Override
    protected NavigationData getNavigation(POMSession session, SiteKey key) {
        NavigationData navigationData = (NavigationData)this.objects.get((Object)session, (Object)key);
        return navigationData != null && (navigationData == NavigationData.EMPTY || navigationData.key == null) ? null : navigationData;
    }

    @Override
    protected void clear() {
        this.cache.clearCache();
    }
}

