/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.portal.pom.config.ExecutorDispatcher;
import org.exoplatform.portal.pom.config.MOPChromatticLifeCycle;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMTask;
import org.exoplatform.portal.pom.config.PortalMOPService;
import org.exoplatform.portal.pom.config.TaskExecutionDecorator;
import org.exoplatform.portal.pom.config.cache.DataCache;
import org.exoplatform.portal.pom.config.cache.PortalNamesCache;
import org.exoplatform.portal.pom.data.OwnerKey;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.jcr.RepositoryService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.mop.core.api.MOPService;
import org.picocontainer.Startable;

public class POMSessionManager
implements Startable {
    private final Logger log = LoggerFactory.getLogger(POMSessionManager.class);
    private static final String CACHE_NAME = "portal.MOPSessionManager";
    private MOPService pomService;
    private final ExoCache<Serializable, Object> cache;
    final ChromatticManager manager;
    private ChromatticLifeCycle configurator;
    private final TaskExecutionDecorator executor;
    private final RepositoryService repositoryService;

    public POMSessionManager(RepositoryService repositoryService, ChromatticManager manager, CacheService cacheService) {
        this.repositoryService = repositoryService;
        this.manager = manager;
        this.cache = cacheService.getCacheInstance(CACHE_NAME);
        this.pomService = null;
        this.executor = new PortalNamesCache(new DataCache(new ExecutorDispatcher()));
    }

    public ChromatticLifeCycle getLifeCycle() {
        return this.configurator;
    }

    public void cachePut(Serializable key, Object value) {
        this.cache.put(key, value);
    }

    public Object cacheGet(Serializable key) {
        Object value = this.cache.get(key);
        return value;
    }

    public void cacheRemove(Serializable key) {
        if (key instanceof PortalKey) {
            final PortalKey portalKey = (PortalKey)key;
            try {
                this.cache.select((CachedObjectSelector)new CachedObjectSelector<Serializable, Object>(){

                    public boolean select(Serializable selectedLocalKey, ObjectCacheInfo<?> ocinfo) {
                        OwnerKey selectedOwnerKey;
                        return selectedLocalKey instanceof OwnerKey && (selectedOwnerKey = (OwnerKey)selectedLocalKey).getType().equals(portalKey.getType()) && selectedOwnerKey.getId().equals(portalKey.getId());
                    }

                    public void onSelect(ExoCache<? extends Serializable, ?> exoCache, Serializable key, ObjectCacheInfo<?> ocinfo) throws Exception {
                        POMSessionManager.this.cache.remove(key);
                    }
                });
            }
            catch (Exception e) {
                this.log.error((Object)"Unexpected error when clearing pom cache", (Throwable)e);
            }
        } else {
            this.cache.remove(key);
        }
    }

    public void start() {
        try {
            MOPChromatticLifeCycle configurator = (MOPChromatticLifeCycle)this.manager.getLifeCycle("mop");
            configurator.manager = this;
            PortalMOPService pomService = new PortalMOPService(configurator.getChromattic());
            pomService.start();
            this.pomService = pomService;
            this.configurator = configurator;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void stop() {
    }

    public void clearCache() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Clearing cache");
        }
        this.cache.clearCache();
    }

    public MOPService getPOMService() {
        return this.pomService;
    }

    public <E extends TaskExecutionDecorator> E getDecorator(Class<E> decoratorClass) {
        return (E)((TaskExecutionDecorator)this.executor.getDecorator(decoratorClass));
    }

    public POMSession getSession() {
        SessionContext context = this.configurator.getContext();
        return context != null ? (POMSession)context.getAttachment("mopsession") : null;
    }

    public POMSession openSession() {
        SessionContext context = this.configurator.openContext();
        return (POMSession)context.getAttachment("mopsession");
    }

    public <V> V execute(POMTask<V> task) throws Exception {
        POMSession session = this.getSession();
        return this.executor.execute(session, task);
    }
}

