/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.migration;

import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.jdbc.migration.AbstractMigrationService;
import org.exoplatform.portal.jdbc.migration.AppReferencesMigrationService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.description.DescriptionServiceImpl;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationServiceImpl;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.SimpleDataCache;
import org.exoplatform.portal.pom.config.POMDataStorage;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.listener.ListenerService;

public class NavigationMigrationService
extends AbstractMigrationService {
    public static final String EVENT_LISTENER_KEY = "PORTAL_NAVIGATIONS_MIGRATION";
    private NavigationService navService;
    private DescriptionService descriptionService;
    private DescriptionServiceImpl jcrDescriptionService;
    private NavigationServiceImpl jcrNavService;

    public NavigationMigrationService(InitParams initParams, POMDataStorage pomStorage, ModelDataStorage modelDataStorage, NavigationService navService, DescriptionService descriptionService, POMSessionManager manager, ListenerService listenerService, RepositoryService repoService, SettingService settingService, AppReferencesMigrationService appReferencesMigrationService) {
        super(initParams, pomStorage, modelDataStorage, listenerService, repoService, settingService, appReferencesMigrationService);
        this.navService = navService;
        SimpleDataCache cache = new SimpleDataCache();
        this.jcrNavService = new NavigationServiceImpl(manager, cache);
        this.descriptionService = descriptionService;
        this.jcrDescriptionService = new DescriptionServiceImpl(manager);
    }

    @Override
    public void doMigrate(PortalKey siteToMigrateKey) {
        SiteKey siteKey = new SiteKey(SiteType.valueOf((String)siteToMigrateKey.getType().toUpperCase()), siteToMigrateKey.getId());
        NavigationContext jcrNav = this.jcrNavService.loadNavigation(siteKey);
        if (jcrNav != null) {
            NavigationContext created = this.navService.loadNavigation(siteKey);
            if (created == null) {
                NavigationContext nav = new NavigationContext(siteKey, jcrNav.getState());
                this.navService.saveNavigation(nav);
                created = this.navService.loadNavigation(siteKey);
            }
            NodeContext root = this.navService.loadNode(NodeModel.SELF_MODEL, created, Scope.ALL, null);
            NodeContext jcrRoot = this.jcrNavService.loadNode(NodeModel.SELF_MODEL, jcrNav, Scope.ALL, null);
            this.migrateNode(root, jcrRoot);
            this.navService.saveNode(root, null);
            this.migrateDescription(root, jcrRoot);
        }
    }

    @Override
    public void doRemove(PortalKey siteToRemoveKey) throws Exception {
        SiteKey siteKey = new SiteKey(siteToRemoveKey.getType(), siteToRemoveKey.getId());
        NavigationContext nav = this.jcrNavService.loadNavigation(siteKey);
        if (nav != null) {
            this.jcrNavService.destroyNavigation(nav);
        }
        this.pomStorage.save();
    }

    private void migrateNode(NodeContext<?> parent, NodeContext<?> jcrParent) {
        for (int i = 0; i < jcrParent.getNodeCount(); ++i) {
            NodeContext jcrChild = (NodeContext)jcrParent.get(i);
            NodeContext child = parent.get(jcrChild.getName());
            if (child == null) {
                child = parent.add(null, jcrChild.getName());
            }
            child.setState(jcrChild.getState());
            child.setHidden(jcrChild.isHidden());
            this.migrateNode(child, jcrChild);
        }
    }

    private void migrateDescription(NodeContext<?> parent, NodeContext<?> jcrParent) {
        for (int i = 0; i < jcrParent.getNodeCount(); ++i) {
            NodeContext jcrChild = (NodeContext)jcrParent.get(i);
            NodeContext child = null;
            child = parent.get(jcrChild.getName());
            if (child == null) continue;
            this.migrateDescription(child, jcrChild);
        }
        Map<Locale, State> descriptions = this.jcrDescriptionService.getDescriptions(jcrParent.getId());
        this.descriptionService.setDescriptions(parent.getId(), descriptions);
    }

    protected boolean hasJCRNavigation() {
        try {
            String query = "select * from mop:navigation where jcr:path like '/production/mop:workspace/%/%/mop:rootnavigation/mop:children/mop:default/mop:children/'";
            ManageableRepository currentRepository = this.repoService.getCurrentRepository();
            Session session = SessionProvider.createSystemProvider().getSession(this.workspaceName, currentRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery(query, "sql");
            if (q instanceof QueryImpl) {
                ((QueryImpl)q).setOffset(0L);
                ((QueryImpl)q).setLimit(1L);
            }
            QueryResult rs = q.execute();
            return rs.getNodes().hasNext();
        }
        catch (RepositoryException ex) {
            this.log.error((Object)"Error while retrieve user portal", (Throwable)ex);
            return false;
        }
    }

    @Override
    protected String getListenerKey() {
        return EVENT_LISTENER_KEY;
    }
}

