/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.MixinType;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.portal.mop.i18n.Language;
import org.exoplatform.portal.mop.i18n.LanguageSpace;
import org.exoplatform.portal.mop.i18n.Resolution;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

@MixinType(name="gtn:i18nized")
public abstract class I18Nized {
    private static final Logger log = LoggerFactory.getLogger(I18Nized.class);

    private static Locale parent(Locale locale) {
        if (locale.getVariant() != null && !locale.getVariant().isEmpty()) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry() != null && !locale.getCountry().isEmpty()) {
            return new Locale(locale.getLanguage());
        }
        return null;
    }

    @Create
    protected abstract LanguageSpace createLanguageSpace();

    @OneToOne
    @Owner
    @MappedBy(value="gtn:languages")
    protected abstract LanguageSpace getLanguageSpace();

    protected abstract void setLanguageSpace(LanguageSpace var1);

    public <M> Resolution<M> resolveMixin(Class<M> mixinType, Locale wantedLocale) {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        if (wantedLocale == null) {
            throw new NullPointerException("No null wanted locale accepted");
        }
        Locale current = wantedLocale;
        while (current != null) {
            M mixin = this.getMixin(mixinType, current, false);
            if (mixin != null) {
                return new Resolution<M>(current, mixin);
            }
            current = I18Nized.parent(current);
        }
        return null;
    }

    public <M> Map<Locale, M> getMixins(Class<M> mixinType) {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        HashMap<Locale, M> mixins = new HashMap<Locale, M>();
        LanguageSpace languageSpace = this.getLanguageSpace();
        if (languageSpace != null) {
            for (Map.Entry<String, Language> entry : languageSpace.getChildren().entrySet()) {
                M mixin = entry.getValue().getMixin(mixinType, false);
                if (mixin == null) continue;
                String lang = entry.getKey();
                try {
                    Locale locale = I18N.parseTagIdentifier((String)lang);
                    mixins.put(locale, mixin);
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)("Skipping locale " + lang + " from retrieved locales for mixin " + mixinType.getName()));
                }
            }
        }
        return mixins;
    }

    public <M> M getMixin(Class<M> mixinType, Locale locale, boolean createMixin) throws NullPointerException, IllegalArgumentException {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        if (locale.getLanguage().length() == 0) {
            throw new IllegalArgumentException("No language set on locale");
        }
        if (locale.getVariant().length() > 0) {
            throw new IllegalArgumentException("No variant cab be set on locale");
        }
        LanguageSpace languageSpace = this.getLanguageSpace();
        if (languageSpace == null && createMixin) {
            languageSpace = this.createLanguageSpace();
            this.setLanguageSpace(languageSpace);
        }
        if (languageSpace != null) {
            return languageSpace.getLanguage(mixinType, I18N.toTagIdentifier((Locale)locale), createMixin);
        }
        return null;
    }

    public <M> Collection<Locale> removeMixin(Class<M> mixinType) {
        if (mixinType == null) {
            throw new NullPointerException("No null mixin type accepted");
        }
        List<Locale> locales = Collections.emptyList();
        LanguageSpace languageSpace = this.getLanguageSpace();
        if (languageSpace != null) {
            for (Language language : languageSpace.getChildren().values()) {
                if (!language.removeMixin(mixinType)) continue;
                String lang = language.getName();
                try {
                    Locale locale = I18N.parseTagIdentifier((String)lang);
                    if (locales.isEmpty()) {
                        locales = new ArrayList<Locale>();
                    }
                    locales.add(locale);
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)("Skipping locale " + lang + " from removed locales for mixin " + mixinType.getName()));
                }
            }
        }
        return locales;
    }
}

