/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.processes.dao.WorkFlowDAO;
import org.exoplatform.processes.entity.WorkFlowEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.ProjectService;

public class ProcessesPermissionsMigration
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getExoLogger(ProcessesPermissionsMigration.class);
    private final PortalContainer container;
    private final WorkFlowDAO workFlowDAO;
    private final SpaceService spaceService;
    private final ProjectService projectService;

    public ProcessesPermissionsMigration(PortalContainer container, WorkFlowDAO workFlowDAO, ProjectService projectService, SpaceService spaceService, InitParams initParams) {
        super(initParams);
        this.container = container;
        this.workFlowDAO = workFlowDAO;
        this.projectService = projectService;
        this.spaceService = spaceService;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        log.info((Object)"Start upgrade of processes permissions");
        boolean upgraded = false;
        boolean shouldUpgrade = true;
        List workflowsToUpdate = this.workFlowDAO.findAll();
        if (workflowsToUpdate == null || workflowsToUpdate.isEmpty()) {
            log.info((Object)"No processes permissions to be upgraded.");
            return;
        }
        ArrayList<WorkFlowEntity> updatedWorkflows = new ArrayList<WorkFlowEntity>();
        for (WorkFlowEntity workflowEntity : workflowsToUpdate) {
            Space space;
            if (workflowEntity.getManager() != null && !workflowEntity.getManager().isEmpty() && workflowEntity.getParticipator() != null && !workflowEntity.getParticipator().isEmpty() || (space = this.getProjectParentSpace(workflowEntity.getProjectId())) == null) continue;
            LinkedList<String> memberships = new LinkedList<String>();
            memberships.add(new MembershipEntry(space.getGroupId(), "manager").toString());
            memberships.add(new MembershipEntry(space.getGroupId(), "member").toString());
            HashSet<String> managers = new HashSet<String>(Arrays.asList((String)memberships.get(0)));
            HashSet<String> participators = new HashSet<String>(Arrays.asList((String)memberships.get(1)));
            participators.addAll(managers);
            workflowEntity.setManager(managers);
            workflowEntity.setParticipator(participators);
            updatedWorkflows.add(workflowEntity);
        }
        if (!updatedWorkflows.isEmpty()) {
            this.workFlowDAO.updateAll(updatedWorkflows);
            upgraded = true;
        } else {
            shouldUpgrade = false;
        }
        if (upgraded) {
            log.info("Processes permissions upgrade proceeded successfully. It took {} ms", new Object[]{System.currentTimeMillis() - startupTime});
        } else if (!shouldUpgrade) {
            log.info((Object)"No processes permissions to be upgraded");
        } else {
            throw new IllegalStateException("Processes permissions upgrade failed due to previous errors");
        }
    }

    private Space getProjectParentSpace(Long projectId) {
        try {
            ProjectDto projectDto = this.projectService.getProject(projectId);
            boolean isProjectInSpace = projectDto.getManager().stream().anyMatch(manager -> manager.contains("/spaces/"));
            if (isProjectInSpace) {
                String participator = (String)projectDto.getParticipator().iterator().next();
                String groupId = participator.substring(participator.indexOf(":") + 1);
                return this.spaceService.getSpaceByGroupId(groupId);
            }
        }
        catch (EntityNotFoundException e) {
            log.error((Object)"Project Not found", (Throwable)e);
        }
        return null;
    }
}

