/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.iframe;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.exoplatform.wiki.rendering.macro.iframe.IFrameMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component(value="iframe")
public class IFrameMacro
extends AbstractMacro<IFrameMacroParameters> {
    public static final String MACRO_CATEGORY_OTHER = "Other";
    private static final String URL_INVALID = "/wiki/templates/wiki/webui/info/UrlInvalid.html";
    private static final String DESCRIPTION = "Embraces a block of text within a fully customizable panel";

    public IFrameMacro() {
        super("IFrame", DESCRIPTION, IFrameMacroParameters.class);
        this.setDefaultCategory(MACRO_CATEGORY_OTHER);
    }

    public List<Block> execute(IFrameMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        StringBuilder rawContent = new StringBuilder("<iframe ");
        if (parameters.getWidth().length() > 0) {
            rawContent.append("width=\"").append(parameters.getWidth()).append("\" ");
        } else {
            rawContent.append("width=\"100%\"");
        }
        if (parameters.getHeight().length() > 0) {
            rawContent.append("height=\"").append(parameters.getHeight()).append("\" ");
        } else {
            rawContent.append("height=\"100%\"");
        }
        rawContent.append("src=\"").append(this.valid(parameters.getSrc()) ? parameters.getSrc() : URL_INVALID).append("\"");
        rawContent.append("></iframe>");
        RawBlock panelBlock = new RawBlock(rawContent.toString(), Syntax.XHTML_1_0);
        return Collections.singletonList(panelBlock);
    }

    private boolean valid(String urlValue) {
        try {
            URL url = new URL(urlValue);
            url.toURI();
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

