/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.AddressLabel;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WalletPreferences
implements Serializable {
    private static final String OVERVIEW_ACCOUNTS_PARAM = "overviewAccounts";
    private static final String PRINCIPAL_ACCOUNT_PARAM = "principalAccount";
    private static final String ENABLE_DELEGATION_PARAM = "enableDelegation";
    private static final String DATA_VERSION_PARAM = "dataVersion";
    private static final String PHRASE_PARAM = "phrase";
    private static final String WALLET_ADDRESS_PARAM = "walletAddress";
    private static final String DEFAULT_GAS_PARAM = "defaultGas";
    private static final String CURRENCY_PARAM = "currency";
    private static final String ADDRESSES_LABELS = "addresesLabels";
    private static final long serialVersionUID = -5725443183560646198L;
    private String walletAddress = null;
    private Integer dataVersion = 0;
    private Long defaultGas = 0L;
    private String currency = "usd";
    private String phrase = null;
    private String principalAccount = null;
    private Set<String> overviewAccounts;
    private Boolean enableDelegation = null;
    private Wallet wallet = null;
    private boolean hasKeyOnServerSide;
    private Set<AddressLabel> addresesLabels;

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(CURRENCY_PARAM, (Object)this.currency);
            jsonObject.put(DEFAULT_GAS_PARAM, (Object)this.defaultGas);
            jsonObject.put(WALLET_ADDRESS_PARAM, (Object)this.walletAddress);
            jsonObject.put(PHRASE_PARAM, (Object)this.phrase);
            jsonObject.put(DATA_VERSION_PARAM, (Object)this.dataVersion);
            if (this.enableDelegation != null) {
                jsonObject.put(ENABLE_DELEGATION_PARAM, (Object)this.enableDelegation);
            }
            if (this.principalAccount != null) {
                jsonObject.put(PRINCIPAL_ACCOUNT_PARAM, (Object)this.principalAccount);
            }
            if (this.overviewAccounts != null) {
                jsonObject.put(OVERVIEW_ACCOUNTS_PARAM, (Object)new JSONArray(this.overviewAccounts));
            }
            if (this.addresesLabels != null) {
                jsonObject.put(ADDRESSES_LABELS, (Object)new JSONArray((Collection)this.addresesLabels.stream().map(label -> new JSONObject(label)).collect(Collectors.toSet())));
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public static final WalletPreferences parseStringToObject(String jsonString) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            WalletPreferences userPreferences = new WalletPreferences();
            if (jsonObject.has(CURRENCY_PARAM)) {
                userPreferences.setCurrency(jsonObject.getString(CURRENCY_PARAM));
            }
            if (jsonObject.has(DEFAULT_GAS_PARAM)) {
                userPreferences.setDefaultGas(jsonObject.getLong(DEFAULT_GAS_PARAM));
            }
            if (jsonObject.has(WALLET_ADDRESS_PARAM)) {
                userPreferences.setWalletAddress(jsonObject.getString(WALLET_ADDRESS_PARAM));
            }
            if (jsonObject.has(PHRASE_PARAM)) {
                userPreferences.setWalletAddress(jsonObject.getString(PHRASE_PARAM));
            }
            if (jsonObject.has(PRINCIPAL_ACCOUNT_PARAM)) {
                userPreferences.setPrincipalAccount(jsonObject.getString(PRINCIPAL_ACCOUNT_PARAM));
            }
            if (jsonObject.has(ENABLE_DELEGATION_PARAM)) {
                userPreferences.setEnableDelegation(jsonObject.getBoolean(ENABLE_DELEGATION_PARAM));
            }
            if (jsonObject.has(DATA_VERSION_PARAM)) {
                userPreferences.setDataVersion(jsonObject.getInt(DATA_VERSION_PARAM));
            }
            userPreferences.setOverviewAccounts(Utils.jsonArrayToList(jsonObject, OVERVIEW_ACCOUNTS_PARAM));
            return userPreferences;
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error while converting JSON String to Object", e);
        }
    }

    public String toString() {
        return this.toJSONString();
    }

    public String getWalletAddress() {
        return this.walletAddress;
    }

    public Integer getDataVersion() {
        return this.dataVersion;
    }

    public Long getDefaultGas() {
        return this.defaultGas;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public String getPrincipalAccount() {
        return this.principalAccount;
    }

    public Set<String> getOverviewAccounts() {
        return this.overviewAccounts;
    }

    public Boolean getEnableDelegation() {
        return this.enableDelegation;
    }

    public Wallet getWallet() {
        return this.wallet;
    }

    public boolean isHasKeyOnServerSide() {
        return this.hasKeyOnServerSide;
    }

    public Set<AddressLabel> getAddresesLabels() {
        return this.addresesLabels;
    }

    public void setWalletAddress(String walletAddress) {
        this.walletAddress = walletAddress;
    }

    public void setDataVersion(Integer dataVersion) {
        this.dataVersion = dataVersion;
    }

    public void setDefaultGas(Long defaultGas) {
        this.defaultGas = defaultGas;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public void setPrincipalAccount(String principalAccount) {
        this.principalAccount = principalAccount;
    }

    public void setOverviewAccounts(Set<String> overviewAccounts) {
        this.overviewAccounts = overviewAccounts;
    }

    public void setEnableDelegation(Boolean enableDelegation) {
        this.enableDelegation = enableDelegation;
    }

    public void setWallet(Wallet wallet) {
        this.wallet = wallet;
    }

    public void setHasKeyOnServerSide(boolean hasKeyOnServerSide) {
        this.hasKeyOnServerSide = hasKeyOnServerSide;
    }

    public void setAddresesLabels(Set<AddressLabel> addresesLabels) {
        this.addresesLabels = addresesLabels;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WalletPreferences)) {
            return false;
        }
        WalletPreferences other = (WalletPreferences)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$walletAddress = this.getWalletAddress();
        String other$walletAddress = other.getWalletAddress();
        return !(this$walletAddress == null ? other$walletAddress != null : !this$walletAddress.equals(other$walletAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WalletPreferences;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $walletAddress = this.getWalletAddress();
        result = result * 59 + ($walletAddress == null ? 43 : $walletAddress.hashCode());
        return result;
    }
}

