/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.reward.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardSettings;
import org.exoplatform.addon.ethereum.wallet.reward.service.RewardSettingsService;
import org.exoplatform.addon.ethereum.wallet.utils.RewardUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/reward/settings")
@RolesAllowed(value={"rewarding", "administrators"})
public class RewardSettingsREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardSettingsREST.class);
    private RewardSettingsService rewardSettingsService;

    public RewardSettingsREST(RewardSettingsService rewardSettingsService) {
        this.rewardSettingsService = rewardSettingsService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding", "administrators"})
    public Response getSettings() {
        try {
            RewardSettings settings = this.rewardSettingsService.getSettings();
            return Response.ok((Object)(settings == null ? new RewardSettings() : settings)).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting reward settings", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="save")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"rewarding", "administrators"})
    public Response saveSettings(RewardSettings rewardSettings) {
        if (rewardSettings == null) {
            LOG.warn((Object)"Bad request sent to server with empty settings");
            return Response.status((int)400).build();
        }
        try {
            this.rewardSettingsService.saveSettings(rewardSettings);
            LOG.info("{} saved reward settings '{}'", new Object[]{RewardUtils.getCurrentUserId(), rewardSettings.toString()});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving reward settings", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

