// Generated by delombok at Wed Apr 24 08:19:20 UTC 2019
package org.exoplatform.addon.ethereum.wallet.model;

import static org.exoplatform.addon.ethereum.wallet.utils.Utils.jsonArrayToList;
import java.io.Serializable;
import java.util.*;
import org.apache.commons.lang3.StringUtils;
import org.json.*;

public class GlobalSettings implements Serializable, Cloneable {
  private static final String USER_WALLET_PARAM = "wallet";
  private static final long serialVersionUID = -4672745644323864680L;
  private static final String CONTRACT_BIN_PARAM = "contractBin";
  private static final String CONTRACT_ABI_PARAM = "contractAbi";
  private static final String DEFAULT_CONTRACTS_TO_DISPLAY_PARAM = "defaultContractsToDisplay";
  private static final String PRINCIPAL_CONTRACT_ADMIN_ADDRESS_PARAM = "principalContractAdminAddress";
  private static final String PRINCIPAL_CONTRACT_ADMIN_NAME_PARAM = "principalContractAdminName";
  private static final String USER_PREFERENCES_PARAM = "userPreferences";
  private static final String USER_HAS_SERVER_KEY_PARAM = "hasKeyOnServerSide";
  private static final String IS_WALLET_ENABLED_PARAM = "isWalletEnabled";
  private static final String IS_ADMIN_PARAM = "isAdmin";
  private static final String DEFAULT_OVERVIEW_ACCOUNTS_PARAM = "defaultOverviewAccounts";
  private static final String DEFAULT_PRINCIPAL_ACCOUNT_PARAM = "defaultPrincipalAccount";
  private static final String INITIAL_FUNDS_PARAM = "initialFunds";
  private static final String DATA_VERSION_PARAM = "dataVersion";
  private static final String MAX_GAS_PRICE_PARAM = "maxGasPrice";
  private static final String NORMAL_GAS_PRICE_PARAM = "normalGasPrice";
  private static final String MIN_GAS_PRICE_PARAM = "minGasPrice";
  private static final String DEFAULT_GAS_PARAM = "defaultGas";
  private static final String DEFAULT_NETWORK_ID_PARAM = "defaultNetworkId";
  private static final String WEBSOCKET_PROVIDER_URL_PARAM = "websocketProviderURL";
  private static final String PROVIDER_URL_PARAM = "providerURL";
  private static final String FUNDS_HOLDER_TYPE_PARAM = "fundsHolderType";
  private static final String FUNDS_HOLDER_PARAM = "fundsHolder";
  private static final String INITIAL_FUNDS_REQUEST_MESSAGE_PARAM = "initialFundsRequestMessage";
  private static final String ACCESS_PERMISSION_PARAM = "accessPermission";
  private static final String ENABLE_DELEGATION_PARAM = "enableDelegation";
  private Integer dataVersion = 0;
  private boolean enableDelegation = false;
  private String accessPermission = null;
  private String fundsHolder = null;
  private String initialFundsRequestMessage = null;
  private String fundsHolderType = null;
  private String providerURL = null;
  private String websocketProviderURL = null;
  private Long defaultNetworkId = 0L;
  private Long defaultGas = 0L;
  private Long minGasPrice = 4000000000L;
  private Long normalGasPrice = 8000000000L;
  private Long maxGasPrice = 15000000000L;
  private String principalContractAdminName = "Admin";
  private String principalContractAdminAddress = null;
  private String defaultPrincipalAccount = null;
  private Set<String> defaultOverviewAccounts;
  private Map<String, Double> initialFunds;
  // Computed
  private boolean walletEnabled = true;
  // Computed
  private boolean isAdmin = false;
  // Computed: managed in other storage location
  private WalletPreferences userPreferences;
  // Computed: managed in other storage location
  private Set<String> defaultContractsToDisplay;
  // Computed: managed in file system storage
  private transient JSONArray contractAbi = null;
  // Computed: managed in file system storage
  private String contractBin = null;

  public String toJSONString(boolean includeTransient) {
    return toJSONObject(includeTransient).toString();
  }

  public JSONObject toJSONObject(boolean includeTransient) {
    JSONObject jsonObject = new JSONObject();
    try {
      jsonObject.put(ENABLE_DELEGATION_PARAM, enableDelegation);
      if (StringUtils.isNotBlank(accessPermission)) {
        jsonObject.put(ACCESS_PERMISSION_PARAM, accessPermission);
      }
      if (StringUtils.isNotBlank(initialFundsRequestMessage)) {
        jsonObject.put(INITIAL_FUNDS_REQUEST_MESSAGE_PARAM, initialFundsRequestMessage);
      }
      if (StringUtils.isNotBlank(fundsHolder)) {
        jsonObject.put(FUNDS_HOLDER_PARAM, fundsHolder);
      }
      if (StringUtils.isNotBlank(fundsHolderType)) {
        jsonObject.put(FUNDS_HOLDER_TYPE_PARAM, fundsHolderType);
      }
      if (StringUtils.isNotBlank(providerURL)) {
        jsonObject.put(PROVIDER_URL_PARAM, providerURL);
      }
      if (StringUtils.isNotBlank(websocketProviderURL)) {
        jsonObject.put(WEBSOCKET_PROVIDER_URL_PARAM, websocketProviderURL);
      }
      if (defaultNetworkId != null && defaultNetworkId != 0) {
        jsonObject.put(DEFAULT_NETWORK_ID_PARAM, defaultNetworkId);
      }
      if (defaultGas != null && defaultGas != 0) {
        jsonObject.put(DEFAULT_GAS_PARAM, defaultGas);
      }
      if (minGasPrice != null && minGasPrice != 0) {
        jsonObject.put(MIN_GAS_PRICE_PARAM, minGasPrice);
      }
      if (normalGasPrice != null && normalGasPrice != 0) {
        jsonObject.put(NORMAL_GAS_PRICE_PARAM, normalGasPrice);
      }
      if (maxGasPrice != null && maxGasPrice != 0) {
        jsonObject.put(MAX_GAS_PRICE_PARAM, maxGasPrice);
      }
      if (dataVersion != null && dataVersion != 0) {
        jsonObject.put(DATA_VERSION_PARAM, dataVersion);
      }
      if (initialFunds != null && !initialFunds.isEmpty()) {
        JSONArray array = new JSONArray();
        Set<String> addresses = initialFunds.keySet();
        for (String address : addresses) {
          JSONObject obj = new JSONObject();
          obj.put("address", address);
          obj.put("amount", initialFunds.get(address));
          array.put(obj);
        }
        jsonObject.put(INITIAL_FUNDS_PARAM, array);
      }
      if (StringUtils.isNotBlank(defaultPrincipalAccount)) {
        jsonObject.put(DEFAULT_PRINCIPAL_ACCOUNT_PARAM, defaultPrincipalAccount);
      }
      if (defaultOverviewAccounts != null && !defaultOverviewAccounts.isEmpty()) {
        jsonObject.put(DEFAULT_OVERVIEW_ACCOUNTS_PARAM, new JSONArray(defaultOverviewAccounts));
      }
      if (includeTransient) {
        jsonObject.put(IS_ADMIN_PARAM, isAdmin);
        jsonObject.put(IS_WALLET_ENABLED_PARAM, walletEnabled);
        if (userPreferences != null) {
          JSONObject userPrefsObject = userPreferences.toJSONObject();
          if (userPreferences.getWallet() != null) {
            userPrefsObject.put(USER_WALLET_PARAM, new JSONObject(userPreferences.getWallet()));
            userPrefsObject.put(USER_HAS_SERVER_KEY_PARAM, userPreferences.isHasKeyOnServerSide());
          }
          jsonObject.put(USER_PREFERENCES_PARAM, userPrefsObject);
        }
        if (StringUtils.isNotBlank(principalContractAdminName)) {
          jsonObject.put(PRINCIPAL_CONTRACT_ADMIN_NAME_PARAM, principalContractAdminName);
        }
        if (StringUtils.isNotBlank(principalContractAdminAddress)) {
          jsonObject.put(PRINCIPAL_CONTRACT_ADMIN_ADDRESS_PARAM, principalContractAdminAddress);
        }
        if (defaultContractsToDisplay != null && !defaultContractsToDisplay.isEmpty()) {
          jsonObject.put(DEFAULT_CONTRACTS_TO_DISPLAY_PARAM, new JSONArray(defaultContractsToDisplay));
        }
        if (contractAbi != null && contractAbi.length() > 0) {
          jsonObject.put(CONTRACT_ABI_PARAM, contractAbi);
        }
        if (StringUtils.isNotBlank(contractBin)) {
          jsonObject.put(CONTRACT_BIN_PARAM, contractBin);
        }
      }
    } catch (JSONException e) {
      throw new IllegalStateException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  @Override
  public String toString() {
    return toJSONString(false);
  }

  public static final GlobalSettings parseStringToObject(GlobalSettings defaultSettings, String jsonString) {
    if (defaultSettings == null) {
      defaultSettings = new GlobalSettings();
    }
    if (StringUtils.isBlank(jsonString)) {
      return defaultSettings.clone();
    }
    try {
      JSONObject jsonObject = new JSONObject(jsonString);
      GlobalSettings globalSettings = new GlobalSettings();
      String storedFundsHolder = jsonObject.has(FUNDS_HOLDER_PARAM) ? jsonObject.getString(FUNDS_HOLDER_PARAM) : defaultSettings.getFundsHolder();
      globalSettings.setFundsHolder(storedFundsHolder);
      String storedFundsHolderType = jsonObject.has(FUNDS_HOLDER_TYPE_PARAM) ? jsonObject.getString(FUNDS_HOLDER_TYPE_PARAM) : defaultSettings.getFundsHolderType();
      globalSettings.setFundsHolderType(storedFundsHolderType);
      Map<String, Double> storedInitialFunds = jsonObject.has(INITIAL_FUNDS_PARAM) ? toMap(jsonObject.getJSONArray(INITIAL_FUNDS_PARAM)) : defaultSettings.getInitialFunds();
      globalSettings.setInitialFunds(storedInitialFunds);
      String storedAccessPermission = jsonObject.has(ACCESS_PERMISSION_PARAM) ? jsonObject.getString(ACCESS_PERMISSION_PARAM) : defaultSettings.getAccessPermission();
      globalSettings.setAccessPermission(storedAccessPermission);
      String storedInitialfundsRequestMessage = jsonObject.has(INITIAL_FUNDS_REQUEST_MESSAGE_PARAM) ? jsonObject.getString(INITIAL_FUNDS_REQUEST_MESSAGE_PARAM) : defaultSettings.getInitialFundsRequestMessage();
      globalSettings.setInitialFundsRequestMessage(storedInitialfundsRequestMessage);
      String storedProviderURL = jsonObject.has(PROVIDER_URL_PARAM) ? jsonObject.getString(PROVIDER_URL_PARAM) : defaultSettings.getProviderURL();
      globalSettings.setProviderURL(storedProviderURL);
      String storedWebsocketProviderURL = jsonObject.has(WEBSOCKET_PROVIDER_URL_PARAM) ? jsonObject.getString(WEBSOCKET_PROVIDER_URL_PARAM) : defaultSettings.getWebsocketProviderURL();
      globalSettings.setWebsocketProviderURL(storedWebsocketProviderURL);
      long storedDefaultNetworkId = jsonObject.has(DEFAULT_NETWORK_ID_PARAM) ? jsonObject.getLong(DEFAULT_NETWORK_ID_PARAM) : defaultSettings.getDefaultNetworkId();
      globalSettings.setDefaultNetworkId(storedDefaultNetworkId);
      long storedDefaultGas = jsonObject.has(DEFAULT_GAS_PARAM) ? jsonObject.getLong(DEFAULT_GAS_PARAM) : defaultSettings.getDefaultGas();
      globalSettings.setDefaultGas(storedDefaultGas);
      long storedMinGasPrice = jsonObject.has(MIN_GAS_PRICE_PARAM) ? jsonObject.getLong(MIN_GAS_PRICE_PARAM) : defaultSettings.getMinGasPrice();
      globalSettings.setMinGasPrice(storedMinGasPrice);
      long storedNormalGasPrice = jsonObject.has(NORMAL_GAS_PRICE_PARAM) ? jsonObject.getLong(NORMAL_GAS_PRICE_PARAM) : defaultSettings.getNormalGasPrice();
      globalSettings.setNormalGasPrice(storedNormalGasPrice);
      long storedMaxGasPrice = jsonObject.has(MAX_GAS_PRICE_PARAM) ? jsonObject.getLong(MAX_GAS_PRICE_PARAM) : defaultSettings.getMaxGasPrice();
      globalSettings.setMaxGasPrice(storedMaxGasPrice);
      boolean storedEnableDelegation = jsonObject.has(ENABLE_DELEGATION_PARAM) ? jsonObject.getBoolean(ENABLE_DELEGATION_PARAM) : defaultSettings.isEnableDelegation();
      globalSettings.setEnableDelegation(storedEnableDelegation);
      String storedDefaultPrincipalAccount = jsonObject.has(DEFAULT_PRINCIPAL_ACCOUNT_PARAM) ? jsonObject.getString(DEFAULT_PRINCIPAL_ACCOUNT_PARAM) : defaultSettings.getDefaultPrincipalAccount();
      globalSettings.setDefaultPrincipalAccount(storedDefaultPrincipalAccount);
      globalSettings.setDefaultOverviewAccounts(jsonArrayToList(jsonObject, DEFAULT_OVERVIEW_ACCOUNTS_PARAM));
      globalSettings.setDataVersion(jsonObject.has(DATA_VERSION_PARAM) ? jsonObject.getInt(DATA_VERSION_PARAM) : 0);
      return globalSettings;
    } catch (JSONException e) {
      throw new IllegalStateException("Error while converting JSON String to Object", e);
    }
  }

  public static final GlobalSettings parseStringToObject(String jsonString) {
    return parseStringToObject(null, jsonString);
  }

  private static Map<String, Double> toMap(JSONArray storedInitialFunds) throws JSONException {
    HashMap<String, Double> map = new HashMap<>();
    if (storedInitialFunds == null || storedInitialFunds.length() == 0) {
      return map;
    }
    for (int i = 0; i < storedInitialFunds.length(); i++) {
      JSONObject obj = storedInitialFunds.getJSONObject(i);
      map.put(obj.getString("address"), obj.getDouble("amount"));
    }
    return map;
  }

  @Override
  @SuppressWarnings("all")
  public GlobalSettings clone() {
    try {
      GlobalSettings clonedSettings = (GlobalSettings) super.clone();
      clonedSettings.setUserPreferences(userPreferences);
      clonedSettings.setAdmin(false);
      clonedSettings.setWalletEnabled(false);
      return clonedSettings;
    } catch (CloneNotSupportedException e) {
      throw new IllegalStateException("Can\'t clone settings");
    }
  }

  @java.lang.SuppressWarnings("all")
  public Integer getDataVersion() {
    return this.dataVersion;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isEnableDelegation() {
    return this.enableDelegation;
  }

  @java.lang.SuppressWarnings("all")
  public String getAccessPermission() {
    return this.accessPermission;
  }

  @java.lang.SuppressWarnings("all")
  public String getFundsHolder() {
    return this.fundsHolder;
  }

  @java.lang.SuppressWarnings("all")
  public String getInitialFundsRequestMessage() {
    return this.initialFundsRequestMessage;
  }

  @java.lang.SuppressWarnings("all")
  public String getFundsHolderType() {
    return this.fundsHolderType;
  }

  @java.lang.SuppressWarnings("all")
  public String getProviderURL() {
    return this.providerURL;
  }

  @java.lang.SuppressWarnings("all")
  public String getWebsocketProviderURL() {
    return this.websocketProviderURL;
  }

  @java.lang.SuppressWarnings("all")
  public Long getDefaultNetworkId() {
    return this.defaultNetworkId;
  }

  @java.lang.SuppressWarnings("all")
  public Long getDefaultGas() {
    return this.defaultGas;
  }

  @java.lang.SuppressWarnings("all")
  public Long getMinGasPrice() {
    return this.minGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public Long getNormalGasPrice() {
    return this.normalGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public Long getMaxGasPrice() {
    return this.maxGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public String getPrincipalContractAdminName() {
    return this.principalContractAdminName;
  }

  @java.lang.SuppressWarnings("all")
  public String getPrincipalContractAdminAddress() {
    return this.principalContractAdminAddress;
  }

  @java.lang.SuppressWarnings("all")
  public String getDefaultPrincipalAccount() {
    return this.defaultPrincipalAccount;
  }

  @java.lang.SuppressWarnings("all")
  public Set<String> getDefaultOverviewAccounts() {
    return this.defaultOverviewAccounts;
  }

  @java.lang.SuppressWarnings("all")
  public Map<String, Double> getInitialFunds() {
    return this.initialFunds;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isWalletEnabled() {
    return this.walletEnabled;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isAdmin() {
    return this.isAdmin;
  }

  @java.lang.SuppressWarnings("all")
  public WalletPreferences getUserPreferences() {
    return this.userPreferences;
  }

  @java.lang.SuppressWarnings("all")
  public Set<String> getDefaultContractsToDisplay() {
    return this.defaultContractsToDisplay;
  }

  @java.lang.SuppressWarnings("all")
  public JSONArray getContractAbi() {
    return this.contractAbi;
  }

  @java.lang.SuppressWarnings("all")
  public String getContractBin() {
    return this.contractBin;
  }

  @java.lang.SuppressWarnings("all")
  public void setDataVersion(final Integer dataVersion) {
    this.dataVersion = dataVersion;
  }

  @java.lang.SuppressWarnings("all")
  public void setEnableDelegation(final boolean enableDelegation) {
    this.enableDelegation = enableDelegation;
  }

  @java.lang.SuppressWarnings("all")
  public void setAccessPermission(final String accessPermission) {
    this.accessPermission = accessPermission;
  }

  @java.lang.SuppressWarnings("all")
  public void setFundsHolder(final String fundsHolder) {
    this.fundsHolder = fundsHolder;
  }

  @java.lang.SuppressWarnings("all")
  public void setInitialFundsRequestMessage(final String initialFundsRequestMessage) {
    this.initialFundsRequestMessage = initialFundsRequestMessage;
  }

  @java.lang.SuppressWarnings("all")
  public void setFundsHolderType(final String fundsHolderType) {
    this.fundsHolderType = fundsHolderType;
  }

  @java.lang.SuppressWarnings("all")
  public void setProviderURL(final String providerURL) {
    this.providerURL = providerURL;
  }

  @java.lang.SuppressWarnings("all")
  public void setWebsocketProviderURL(final String websocketProviderURL) {
    this.websocketProviderURL = websocketProviderURL;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultNetworkId(final Long defaultNetworkId) {
    this.defaultNetworkId = defaultNetworkId;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultGas(final Long defaultGas) {
    this.defaultGas = defaultGas;
  }

  @java.lang.SuppressWarnings("all")
  public void setMinGasPrice(final Long minGasPrice) {
    this.minGasPrice = minGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public void setNormalGasPrice(final Long normalGasPrice) {
    this.normalGasPrice = normalGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public void setMaxGasPrice(final Long maxGasPrice) {
    this.maxGasPrice = maxGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public void setPrincipalContractAdminName(final String principalContractAdminName) {
    this.principalContractAdminName = principalContractAdminName;
  }

  @java.lang.SuppressWarnings("all")
  public void setPrincipalContractAdminAddress(final String principalContractAdminAddress) {
    this.principalContractAdminAddress = principalContractAdminAddress;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultPrincipalAccount(final String defaultPrincipalAccount) {
    this.defaultPrincipalAccount = defaultPrincipalAccount;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultOverviewAccounts(final Set<String> defaultOverviewAccounts) {
    this.defaultOverviewAccounts = defaultOverviewAccounts;
  }

  @java.lang.SuppressWarnings("all")
  public void setInitialFunds(final Map<String, Double> initialFunds) {
    this.initialFunds = initialFunds;
  }

  @java.lang.SuppressWarnings("all")
  public void setWalletEnabled(final boolean walletEnabled) {
    this.walletEnabled = walletEnabled;
  }

  @java.lang.SuppressWarnings("all")
  public void setAdmin(final boolean isAdmin) {
    this.isAdmin = isAdmin;
  }

  @java.lang.SuppressWarnings("all")
  public void setUserPreferences(final WalletPreferences userPreferences) {
    this.userPreferences = userPreferences;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultContractsToDisplay(final Set<String> defaultContractsToDisplay) {
    this.defaultContractsToDisplay = defaultContractsToDisplay;
  }

  @java.lang.SuppressWarnings("all")
  public void setContractAbi(final JSONArray contractAbi) {
    this.contractAbi = contractAbi;
  }

  @java.lang.SuppressWarnings("all")
  public void setContractBin(final String contractBin) {
    this.contractBin = contractBin;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof GlobalSettings)) return false;
    final GlobalSettings other = (GlobalSettings) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$dataVersion = this.getDataVersion();
    final java.lang.Object other$dataVersion = other.getDataVersion();
    if (this$dataVersion == null ? other$dataVersion != null : !this$dataVersion.equals(other$dataVersion)) return false;
    if (this.isEnableDelegation() != other.isEnableDelegation()) return false;
    final java.lang.Object this$accessPermission = this.getAccessPermission();
    final java.lang.Object other$accessPermission = other.getAccessPermission();
    if (this$accessPermission == null ? other$accessPermission != null : !this$accessPermission.equals(other$accessPermission)) return false;
    final java.lang.Object this$fundsHolder = this.getFundsHolder();
    final java.lang.Object other$fundsHolder = other.getFundsHolder();
    if (this$fundsHolder == null ? other$fundsHolder != null : !this$fundsHolder.equals(other$fundsHolder)) return false;
    final java.lang.Object this$initialFundsRequestMessage = this.getInitialFundsRequestMessage();
    final java.lang.Object other$initialFundsRequestMessage = other.getInitialFundsRequestMessage();
    if (this$initialFundsRequestMessage == null ? other$initialFundsRequestMessage != null : !this$initialFundsRequestMessage.equals(other$initialFundsRequestMessage)) return false;
    final java.lang.Object this$fundsHolderType = this.getFundsHolderType();
    final java.lang.Object other$fundsHolderType = other.getFundsHolderType();
    if (this$fundsHolderType == null ? other$fundsHolderType != null : !this$fundsHolderType.equals(other$fundsHolderType)) return false;
    final java.lang.Object this$providerURL = this.getProviderURL();
    final java.lang.Object other$providerURL = other.getProviderURL();
    if (this$providerURL == null ? other$providerURL != null : !this$providerURL.equals(other$providerURL)) return false;
    final java.lang.Object this$websocketProviderURL = this.getWebsocketProviderURL();
    final java.lang.Object other$websocketProviderURL = other.getWebsocketProviderURL();
    if (this$websocketProviderURL == null ? other$websocketProviderURL != null : !this$websocketProviderURL.equals(other$websocketProviderURL)) return false;
    final java.lang.Object this$defaultNetworkId = this.getDefaultNetworkId();
    final java.lang.Object other$defaultNetworkId = other.getDefaultNetworkId();
    if (this$defaultNetworkId == null ? other$defaultNetworkId != null : !this$defaultNetworkId.equals(other$defaultNetworkId)) return false;
    final java.lang.Object this$defaultGas = this.getDefaultGas();
    final java.lang.Object other$defaultGas = other.getDefaultGas();
    if (this$defaultGas == null ? other$defaultGas != null : !this$defaultGas.equals(other$defaultGas)) return false;
    final java.lang.Object this$minGasPrice = this.getMinGasPrice();
    final java.lang.Object other$minGasPrice = other.getMinGasPrice();
    if (this$minGasPrice == null ? other$minGasPrice != null : !this$minGasPrice.equals(other$minGasPrice)) return false;
    final java.lang.Object this$normalGasPrice = this.getNormalGasPrice();
    final java.lang.Object other$normalGasPrice = other.getNormalGasPrice();
    if (this$normalGasPrice == null ? other$normalGasPrice != null : !this$normalGasPrice.equals(other$normalGasPrice)) return false;
    final java.lang.Object this$maxGasPrice = this.getMaxGasPrice();
    final java.lang.Object other$maxGasPrice = other.getMaxGasPrice();
    if (this$maxGasPrice == null ? other$maxGasPrice != null : !this$maxGasPrice.equals(other$maxGasPrice)) return false;
    final java.lang.Object this$principalContractAdminName = this.getPrincipalContractAdminName();
    final java.lang.Object other$principalContractAdminName = other.getPrincipalContractAdminName();
    if (this$principalContractAdminName == null ? other$principalContractAdminName != null : !this$principalContractAdminName.equals(other$principalContractAdminName)) return false;
    final java.lang.Object this$principalContractAdminAddress = this.getPrincipalContractAdminAddress();
    final java.lang.Object other$principalContractAdminAddress = other.getPrincipalContractAdminAddress();
    if (this$principalContractAdminAddress == null ? other$principalContractAdminAddress != null : !this$principalContractAdminAddress.equals(other$principalContractAdminAddress)) return false;
    final java.lang.Object this$defaultPrincipalAccount = this.getDefaultPrincipalAccount();
    final java.lang.Object other$defaultPrincipalAccount = other.getDefaultPrincipalAccount();
    if (this$defaultPrincipalAccount == null ? other$defaultPrincipalAccount != null : !this$defaultPrincipalAccount.equals(other$defaultPrincipalAccount)) return false;
    final java.lang.Object this$defaultOverviewAccounts = this.getDefaultOverviewAccounts();
    final java.lang.Object other$defaultOverviewAccounts = other.getDefaultOverviewAccounts();
    if (this$defaultOverviewAccounts == null ? other$defaultOverviewAccounts != null : !this$defaultOverviewAccounts.equals(other$defaultOverviewAccounts)) return false;
    final java.lang.Object this$initialFunds = this.getInitialFunds();
    final java.lang.Object other$initialFunds = other.getInitialFunds();
    if (this$initialFunds == null ? other$initialFunds != null : !this$initialFunds.equals(other$initialFunds)) return false;
    if (this.isWalletEnabled() != other.isWalletEnabled()) return false;
    if (this.isAdmin() != other.isAdmin()) return false;
    final java.lang.Object this$userPreferences = this.getUserPreferences();
    final java.lang.Object other$userPreferences = other.getUserPreferences();
    if (this$userPreferences == null ? other$userPreferences != null : !this$userPreferences.equals(other$userPreferences)) return false;
    final java.lang.Object this$defaultContractsToDisplay = this.getDefaultContractsToDisplay();
    final java.lang.Object other$defaultContractsToDisplay = other.getDefaultContractsToDisplay();
    if (this$defaultContractsToDisplay == null ? other$defaultContractsToDisplay != null : !this$defaultContractsToDisplay.equals(other$defaultContractsToDisplay)) return false;
    final java.lang.Object this$contractAbi = this.getContractAbi();
    final java.lang.Object other$contractAbi = other.getContractAbi();
    if (this$contractAbi == null ? other$contractAbi != null : !this$contractAbi.equals(other$contractAbi)) return false;
    final java.lang.Object this$contractBin = this.getContractBin();
    final java.lang.Object other$contractBin = other.getContractBin();
    if (this$contractBin == null ? other$contractBin != null : !this$contractBin.equals(other$contractBin)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof GlobalSettings;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $dataVersion = this.getDataVersion();
    result = result * PRIME + ($dataVersion == null ? 43 : $dataVersion.hashCode());
    result = result * PRIME + (this.isEnableDelegation() ? 79 : 97);
    final java.lang.Object $accessPermission = this.getAccessPermission();
    result = result * PRIME + ($accessPermission == null ? 43 : $accessPermission.hashCode());
    final java.lang.Object $fundsHolder = this.getFundsHolder();
    result = result * PRIME + ($fundsHolder == null ? 43 : $fundsHolder.hashCode());
    final java.lang.Object $initialFundsRequestMessage = this.getInitialFundsRequestMessage();
    result = result * PRIME + ($initialFundsRequestMessage == null ? 43 : $initialFundsRequestMessage.hashCode());
    final java.lang.Object $fundsHolderType = this.getFundsHolderType();
    result = result * PRIME + ($fundsHolderType == null ? 43 : $fundsHolderType.hashCode());
    final java.lang.Object $providerURL = this.getProviderURL();
    result = result * PRIME + ($providerURL == null ? 43 : $providerURL.hashCode());
    final java.lang.Object $websocketProviderURL = this.getWebsocketProviderURL();
    result = result * PRIME + ($websocketProviderURL == null ? 43 : $websocketProviderURL.hashCode());
    final java.lang.Object $defaultNetworkId = this.getDefaultNetworkId();
    result = result * PRIME + ($defaultNetworkId == null ? 43 : $defaultNetworkId.hashCode());
    final java.lang.Object $defaultGas = this.getDefaultGas();
    result = result * PRIME + ($defaultGas == null ? 43 : $defaultGas.hashCode());
    final java.lang.Object $minGasPrice = this.getMinGasPrice();
    result = result * PRIME + ($minGasPrice == null ? 43 : $minGasPrice.hashCode());
    final java.lang.Object $normalGasPrice = this.getNormalGasPrice();
    result = result * PRIME + ($normalGasPrice == null ? 43 : $normalGasPrice.hashCode());
    final java.lang.Object $maxGasPrice = this.getMaxGasPrice();
    result = result * PRIME + ($maxGasPrice == null ? 43 : $maxGasPrice.hashCode());
    final java.lang.Object $principalContractAdminName = this.getPrincipalContractAdminName();
    result = result * PRIME + ($principalContractAdminName == null ? 43 : $principalContractAdminName.hashCode());
    final java.lang.Object $principalContractAdminAddress = this.getPrincipalContractAdminAddress();
    result = result * PRIME + ($principalContractAdminAddress == null ? 43 : $principalContractAdminAddress.hashCode());
    final java.lang.Object $defaultPrincipalAccount = this.getDefaultPrincipalAccount();
    result = result * PRIME + ($defaultPrincipalAccount == null ? 43 : $defaultPrincipalAccount.hashCode());
    final java.lang.Object $defaultOverviewAccounts = this.getDefaultOverviewAccounts();
    result = result * PRIME + ($defaultOverviewAccounts == null ? 43 : $defaultOverviewAccounts.hashCode());
    final java.lang.Object $initialFunds = this.getInitialFunds();
    result = result * PRIME + ($initialFunds == null ? 43 : $initialFunds.hashCode());
    result = result * PRIME + (this.isWalletEnabled() ? 79 : 97);
    result = result * PRIME + (this.isAdmin() ? 79 : 97);
    final java.lang.Object $userPreferences = this.getUserPreferences();
    result = result * PRIME + ($userPreferences == null ? 43 : $userPreferences.hashCode());
    final java.lang.Object $defaultContractsToDisplay = this.getDefaultContractsToDisplay();
    result = result * PRIME + ($defaultContractsToDisplay == null ? 43 : $defaultContractsToDisplay.hashCode());
    final java.lang.Object $contractAbi = this.getContractAbi();
    result = result * PRIME + ($contractAbi == null ? 43 : $contractAbi.hashCode());
    final java.lang.Object $contractBin = this.getContractBin();
    result = result * PRIME + ($contractBin == null ? 43 : $contractBin.hashCode());
    return result;
  }

  @java.lang.SuppressWarnings("all")
  public GlobalSettings() {
  }
}
