/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.model;

import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class TransactionMessage
implements Serializable {
    private static final long serialVersionUID = 658273092293607458L;
    private String hash;
    private String label;
    private String message;
    private String sender;

    public TransactionMessage(String transactionDetails) {
        if (StringUtils.isNotBlank((String)transactionDetails)) {
            String[] transactionDetailsArray = transactionDetails.split(";");
            this.hash = transactionDetailsArray[0];
            this.label = transactionDetailsArray.length > 1 ? TransactionMessage.decode(transactionDetailsArray[1]) : null;
            this.message = transactionDetailsArray.length > 2 ? TransactionMessage.decode(transactionDetailsArray[2]) : null;
        }
    }

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("hash", (Object)this.hash);
            jsonObject.put("label", (Object)this.label);
            jsonObject.put("message", (Object)this.message);
            jsonObject.put("sender", (Object)this.sender);
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public String toString() {
        return this.hash + ";" + TransactionMessage.encode(this.label) + ";" + TransactionMessage.encode(this.message);
    }

    private static String encode(String content) {
        try {
            return StringUtils.isBlank((String)content) ? "" : URLEncoder.encode(content.trim(), "UTF-8");
        }
        catch (Exception e) {
            return content;
        }
    }

    private static String decode(String content) {
        try {
            return StringUtils.isBlank((String)content) ? "" : URLDecoder.decode(content.trim(), "UTF-8");
        }
        catch (Exception e) {
            return content;
        }
    }

    public String getHash() {
        return this.hash;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSender() {
        return this.sender;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionMessage)) {
            return false;
        }
        TransactionMessage other = (TransactionMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        return !(this$sender == null ? other$sender != null : !this$sender.equals(other$sender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        return result;
    }

    public TransactionMessage(String hash, String label, String message, String sender) {
        this.hash = hash;
        this.label = label;
        this.message = message;
        this.sender = sender;
    }

    public TransactionMessage() {
    }
}

