/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.fork;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.addon.ethereum.wallet.fork.Keccak;
import org.exoplatform.addon.ethereum.wallet.fork.Utils;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.utils.Numeric;

public class EventEncoder {
    private EventEncoder() {
    }

    public static String encode(Event event) {
        String methodSignature = EventEncoder.buildMethodSignature(event.getName(), event.getParameters());
        return EventEncoder.buildEventSignature(methodSignature);
    }

    static <T extends Type> String buildMethodSignature(String methodName, List<TypeReference<T>> parameters) {
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append("(");
        String params = parameters.stream().map(p -> Utils.getTypeName(p)).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString();
    }

    public static String buildEventSignature(String methodSignature) {
        byte[] input = methodSignature.getBytes();
        byte[] hash = EventEncoder.sha3(input, 0, input.length);
        return Numeric.toHexString((byte[])hash);
    }

    public static byte[] sha3(byte[] input, int offset, int length) {
        Keccak.Digest256 kecc = new Keccak.Digest256();
        kecc.update(input, offset, length);
        return kecc.digest();
    }
}

