/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.contract;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import rx.Observable;
import rx.functions.Func1;

public class ERTTokenV1
extends Contract {
    private static final String BINARY = "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";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_APPROVE = "approve";
    public static final String FUNC_INITIALIZED = "initialized";
    public static final String FUNC_REMOVEADMIN = "removeAdmin";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_INITIALIZE = "initialize";
    public static final String FUNC_TRANSFERFROM = "transferFrom";
    public static final String FUNC_DECIMALS = "decimals";
    public static final String FUNC_UPGRADEIMPLEMENTATION = "upgradeImplementation";
    public static final String FUNC_GETSELLPRICE = "getSellPrice";
    public static final String FUNC_ISADMIN = "isAdmin";
    public static final String FUNC_ADDADMIN = "addAdmin";
    public static final String FUNC_VERSION = "version";
    public static final String FUNC_PAUSED = "paused";
    public static final String FUNC_DISAPPROVEACCOUNT = "disapproveAccount";
    public static final String FUNC_UPGRADEDATA = "upgradeData";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_PAUSE = "pause";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_GETDATAADDRESS = "getDataAddress";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_UPGRADEDATAANDIMPLEMENTATION = "upgradeDataAndImplementation";
    public static final String FUNC_TRANSFER = "transfer";
    public static final String FUNC_ISAPPROVEDACCOUNT = "isApprovedAccount";
    public static final String FUNC_GETADMINLEVEL = "getAdminLevel";
    public static final String FUNC_ISPAUSED = "isPaused";
    public static final String FUNC_SETSYMBOL = "setSymbol";
    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";
    public static final String FUNC_SETNAME = "setName";
    public static final String FUNC_ALLOWANCE = "allowance";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_UNPAUSE = "unPause";
    public static final String FUNC_APPROVEACCOUNT = "approveAccount";
    public static final String FUNC_SETSELLPRICE = "setSellPrice";
    public static final Event UPGRADED_EVENT = new Event("Upgraded", Arrays.asList(new TypeReference<Uint16>(){}, new TypeReference<Address>(){}));
    public static final Event UPGRADEDDATA_EVENT = new Event("UpgradedData", Arrays.asList(new TypeReference<Uint16>(){}, new TypeReference<Address>(){}));
    public static final Event TOKENPRICECHANGED_EVENT = new Event("TokenPriceChanged", Arrays.asList(new TypeReference<Uint256>(){}));
    public static final Event TRANSACTIONFEE_EVENT = new Event("TransactionFee", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
    public static final Event NOSUFFICIENTFUND_EVENT = new Event("NoSufficientFund", Arrays.asList(new TypeReference<Uint256>(){}));
    public static final Event DEPOSITRECEIVED_EVENT = new Event("DepositReceived", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint256>(){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event APPROVAL_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event APPROVEDACCOUNT_EVENT = new Event("ApprovedAccount", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event DISAPPROVEDACCOUNT_EVENT = new Event("DisapprovedAccount", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event CONTRACTPAUSED_EVENT = new Event("ContractPaused", Arrays.asList(new TypeReference[0]));
    public static final Event CONTRACTUNPAUSED_EVENT = new Event("ContractUnPaused", Arrays.asList(new TypeReference[0]));
    public static final Event ADDEDADMIN_EVENT = new Event("AddedAdmin", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint8>(){}));
    public static final Event REMOVEDADMIN_EVENT = new Event("RemovedAdmin", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", Arrays.asList(new TypeReference<Address>(){}));

    @Deprecated
    protected ERTTokenV1(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERTTokenV1(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERTTokenV1(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERTTokenV1(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<String> name() {
        Function function = new Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> approve(String _spender, BigInteger _value) {
        Function function = new Function(FUNC_APPROVE, Arrays.asList(new Address(_spender), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> initialized() {
        Function function = new Function(FUNC_INITIALIZED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> removeAdmin(String _target) {
        Function function = new Function(FUNC_REMOVEADMIN, Arrays.asList(new Address(_target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> totalSupply() {
        Function function = new Function(FUNC_TOTALSUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> initialize(BigInteger _initialAmount, String _tokenName, BigInteger _decimalUnits, String _tokenSymbol) {
        Function function = new Function(FUNC_INITIALIZE, Arrays.asList(new Uint256(_initialAmount), new Utf8String(_tokenName), new Uint8(_decimalUnits), new Utf8String(_tokenSymbol)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> transferFrom(String _from, String _to, BigInteger _value) {
        Function function = new Function(FUNC_TRANSFERFROM, Arrays.asList(new Address(_from), new Address(_to), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> decimals() {
        Function function = new Function(FUNC_DECIMALS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> upgradeImplementation(String _proxy, BigInteger _version, String _newImplementation) {
        Function function = new Function(FUNC_UPGRADEIMPLEMENTATION, Arrays.asList(new Address(_proxy), new Uint16(_version), new Address(_newImplementation)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> getSellPrice() {
        Function function = new Function(FUNC_GETSELLPRICE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> isAdmin(String _target, BigInteger _level) {
        Function function = new Function(FUNC_ISADMIN, Arrays.asList(new Address(_target), new Uint8(_level)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> addAdmin(String _target, BigInteger _level) {
        Function function = new Function(FUNC_ADDADMIN, Arrays.asList(new Address(_target), new Uint8(_level)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> version() {
        Function function = new Function(FUNC_VERSION, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint16>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> paused() {
        Function function = new Function(FUNC_PAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> disapproveAccount(String _target) {
        Function function = new Function(FUNC_DISAPPROVEACCOUNT, Arrays.asList(new Address(_target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> upgradeData(BigInteger _dataVersion, String _dataAddress) {
        Function function = new Function(FUNC_UPGRADEDATA, Arrays.asList(new Uint16(_dataVersion), new Address(_dataAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> balanceOf(String _target) {
        Function function = new Function(FUNC_BALANCEOF, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> pause() {
        Function function = new Function(FUNC_PAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> owner() {
        Function function = new Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> getDataAddress(BigInteger _version) {
        Function function = new Function(FUNC_GETDATAADDRESS, Arrays.asList(new Uint16(_version)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> symbol() {
        Function function = new Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> upgradeDataAndImplementation(String _proxy, BigInteger _version, String _newImplementation, BigInteger _dataVersion, String _dataAddress) {
        Function function = new Function(FUNC_UPGRADEDATAANDIMPLEMENTATION, Arrays.asList(new Address(_proxy), new Uint16(_version), new Address(_newImplementation), new Uint16(_dataVersion), new Address(_dataAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> transfer(String _to, BigInteger _value) {
        Function function = new Function(FUNC_TRANSFER, Arrays.asList(new Address(_to), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> isApprovedAccount(String _target) {
        Function function = new Function(FUNC_ISAPPROVEDACCOUNT, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<BigInteger> getAdminLevel(String _target) {
        Function function = new Function(FUNC_GETADMINLEVEL, Arrays.asList(new Address(_target)), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> isPaused() {
        Function function = new Function(FUNC_ISPAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> setSymbol(String _symbol) {
        Function function = new Function(FUNC_SETSYMBOL, Arrays.asList(new Utf8String(_symbol)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> implementationAddress() {
        Function function = new Function(FUNC_IMPLEMENTATIONADDRESS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> setName(String _name) {
        Function function = new Function(FUNC_SETNAME, Arrays.asList(new Utf8String(_name)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> allowance(String _target, String _spender) {
        Function function = new Function(FUNC_ALLOWANCE, Arrays.asList(new Address(_target), new Address(_spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> transferOwnership(String _newOwner) {
        Function function = new Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(_newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> unPause() {
        Function function = new Function(FUNC_UNPAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> approveAccount(String _target) {
        Function function = new Function(FUNC_APPROVEACCOUNT, Arrays.asList(new Address(_target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> setSellPrice(BigInteger _value) {
        Function function = new Function(FUNC_SETSELLPRICE, Arrays.asList(new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(UPGRADED_EVENT, transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementationVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.implementationAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<UpgradedEventResponse> upgradedEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, UpgradedEventResponse>(){

            public UpgradedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(UPGRADED_EVENT, log);
                UpgradedEventResponse typedResponse = new UpgradedEventResponse();
                typedResponse.log = log;
                typedResponse.implementationVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.implementationAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<UpgradedEventResponse> upgradedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADED_EVENT));
        return this.upgradedEventObservable(filter);
    }

    public List<UpgradedDataEventResponse> getUpgradedDataEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(UPGRADEDDATA_EVENT, transactionReceipt);
        ArrayList<UpgradedDataEventResponse> responses = new ArrayList<UpgradedDataEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.dataVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.dataAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<UpgradedDataEventResponse> upgradedDataEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, UpgradedDataEventResponse>(){

            public UpgradedDataEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(UPGRADEDDATA_EVENT, log);
                UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
                typedResponse.log = log;
                typedResponse.dataVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.dataAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<UpgradedDataEventResponse> upgradedDataEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADEDDATA_EVENT));
        return this.upgradedDataEventObservable(filter);
    }

    public List<TokenPriceChangedEventResponse> getTokenPriceChangedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, transactionReceipt);
        ArrayList<TokenPriceChangedEventResponse> responses = new ArrayList<TokenPriceChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.tokenPrice = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TokenPriceChangedEventResponse> tokenPriceChangedEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TokenPriceChangedEventResponse>(){

            public TokenPriceChangedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, log);
                TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
                typedResponse.log = log;
                typedResponse.tokenPrice = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TokenPriceChangedEventResponse> tokenPriceChangedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TOKENPRICECHANGED_EVENT));
        return this.tokenPriceChangedEventObservable(filter);
    }

    public List<TransactionFeeEventResponse> getTransactionFeeEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSACTIONFEE_EVENT, transactionReceipt);
        ArrayList<TransactionFeeEventResponse> responses = new ArrayList<TransactionFeeEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.tokenFee = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.etherFeeRefund = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransactionFeeEventResponse> transactionFeeEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TransactionFeeEventResponse>(){

            public TransactionFeeEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSACTIONFEE_EVENT, log);
                TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.tokenFee = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                typedResponse.etherFeeRefund = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransactionFeeEventResponse> transactionFeeEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSACTIONFEE_EVENT));
        return this.transactionFeeEventObservable(filter);
    }

    public List<NoSufficientFundEventResponse> getNoSufficientFundEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, transactionReceipt);
        ArrayList<NoSufficientFundEventResponse> responses = new ArrayList<NoSufficientFundEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.balance = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<NoSufficientFundEventResponse> noSufficientFundEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, NoSufficientFundEventResponse>(){

            public NoSufficientFundEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, log);
                NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
                typedResponse.log = log;
                typedResponse.balance = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<NoSufficientFundEventResponse> noSufficientFundEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)NOSUFFICIENTFUND_EVENT));
        return this.noSufficientFundEventObservable(filter);
    }

    public List<DepositReceivedEventResponse> getDepositReceivedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, transactionReceipt);
        ArrayList<DepositReceivedEventResponse> responses = new ArrayList<DepositReceivedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<DepositReceivedEventResponse> depositReceivedEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, DepositReceivedEventResponse>(){

            public DepositReceivedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, log);
                DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<DepositReceivedEventResponse> depositReceivedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DEPOSITRECEIVED_EVENT));
        return this.depositReceivedEventObservable(filter);
    }

    public List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferEventResponse> transferEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TransferEventResponse>(){

            public TransferEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferEventResponse> transferEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFER_EVENT));
        return this.transferEventObservable(filter);
    }

    public List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ApprovalEventResponse> approvalEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, ApprovalEventResponse>(){

            public ApprovalEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(APPROVAL_EVENT, log);
                ApprovalEventResponse typedResponse = new ApprovalEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<ApprovalEventResponse> approvalEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVAL_EVENT));
        return this.approvalEventObservable(filter);
    }

    public List<ApprovedAccountEventResponse> getApprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<ApprovedAccountEventResponse> responses = new ArrayList<ApprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ApprovedAccountEventResponse> approvedAccountEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, ApprovedAccountEventResponse>(){

            public ApprovedAccountEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, log);
                ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<ApprovedAccountEventResponse> approvedAccountEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVEDACCOUNT_EVENT));
        return this.approvedAccountEventObservable(filter);
    }

    public List<DisapprovedAccountEventResponse> getDisapprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<DisapprovedAccountEventResponse> responses = new ArrayList<DisapprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<DisapprovedAccountEventResponse> disapprovedAccountEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, DisapprovedAccountEventResponse>(){

            public DisapprovedAccountEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, log);
                DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<DisapprovedAccountEventResponse> disapprovedAccountEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DISAPPROVEDACCOUNT_EVENT));
        return this.disapprovedAccountEventObservable(filter);
    }

    public List<ContractPausedEventResponse> getContractPausedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(CONTRACTPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractPausedEventResponse> responses = new ArrayList<ContractPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ContractPausedEventResponse> contractPausedEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, ContractPausedEventResponse>(){

            public ContractPausedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(CONTRACTPAUSED_EVENT, log);
                ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Observable<ContractPausedEventResponse> contractPausedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CONTRACTPAUSED_EVENT));
        return this.contractPausedEventObservable(filter);
    }

    public List<ContractUnPausedEventResponse> getContractUnPausedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractUnPausedEventResponse> responses = new ArrayList<ContractUnPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ContractUnPausedEventResponse> contractUnPausedEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, ContractUnPausedEventResponse>(){

            public ContractUnPausedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, log);
                ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Observable<ContractUnPausedEventResponse> contractUnPausedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CONTRACTUNPAUSED_EVENT));
        return this.contractUnPausedEventObservable(filter);
    }

    public List<AddedAdminEventResponse> getAddedAdminEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(ADDEDADMIN_EVENT, transactionReceipt);
        ArrayList<AddedAdminEventResponse> responses = new ArrayList<AddedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.level = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<AddedAdminEventResponse> addedAdminEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, AddedAdminEventResponse>(){

            public AddedAdminEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(ADDEDADMIN_EVENT, log);
                AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.level = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<AddedAdminEventResponse> addedAdminEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ADDEDADMIN_EVENT));
        return this.addedAdminEventObservable(filter);
    }

    public List<RemovedAdminEventResponse> getRemovedAdminEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(REMOVEDADMIN_EVENT, transactionReceipt);
        ArrayList<RemovedAdminEventResponse> responses = new ArrayList<RemovedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<RemovedAdminEventResponse> removedAdminEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, RemovedAdminEventResponse>(){

            public RemovedAdminEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(REMOVEDADMIN_EVENT, log);
                RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<RemovedAdminEventResponse> removedAdminEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)REMOVEDADMIN_EVENT));
        return this.removedAdminEventObservable(filter);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferOwnershipEventResponse> transferOwnershipEventObservable(EthFilter filter) {
        return this.web3j.ethLogObservable(filter).map((Func1)new Func1<Log, TransferOwnershipEventResponse>(){

            public TransferOwnershipEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferOwnershipEventResponse> transferOwnershipEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFEROWNERSHIP_EVENT));
        return this.transferOwnershipEventObservable(filter);
    }

    @Deprecated
    public static ERTTokenV1 load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV1(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERTTokenV1 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV1(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERTTokenV1 load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERTTokenV1(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERTTokenV1 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERTTokenV1(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static class TransferOwnershipEventResponse {
        public Log log;
        public String newOwner;
    }

    public static class RemovedAdminEventResponse {
        public Log log;
        public String target;
    }

    public static class AddedAdminEventResponse {
        public Log log;
        public String target;
        public BigInteger level;
    }

    public static class ContractUnPausedEventResponse {
        public Log log;
    }

    public static class ContractPausedEventResponse {
        public Log log;
    }

    public static class DisapprovedAccountEventResponse {
        public Log log;
        public String target;
    }

    public static class ApprovedAccountEventResponse {
        public Log log;
        public String target;
    }

    public static class ApprovalEventResponse {
        public Log log;
        public String _owner;
        public String _spender;
        public BigInteger _value;
    }

    public static class TransferEventResponse {
        public Log log;
        public String _from;
        public String _to;
        public BigInteger _value;
    }

    public static class DepositReceivedEventResponse {
        public Log log;
        public String from;
        public BigInteger amount;
    }

    public static class NoSufficientFundEventResponse {
        public Log log;
        public BigInteger balance;
    }

    public static class TransactionFeeEventResponse {
        public Log log;
        public String from;
        public BigInteger tokenFee;
        public BigInteger etherFeeRefund;
    }

    public static class TokenPriceChangedEventResponse {
        public Log log;
        public BigInteger tokenPrice;
    }

    public static class UpgradedDataEventResponse {
        public Log log;
        public BigInteger dataVersion;
        public String dataAddress;
    }

    public static class UpgradedEventResponse {
        public Log log;
        public BigInteger implementationVersion;
        public String implementationAddress;
    }
}

