/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.ethereum.wallet.service.WalletKudosService;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/kudos")
public class WalletKudosREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletKudosREST.class);
    private WalletKudosService extendedWalletService;

    public WalletKudosREST(WalletKudosService extendedWalletService) {
        this.extendedWalletService = extendedWalletService;
    }

    @Path(value="getKudosBudget")
    @GET
    @RolesAllowed(value={"administrators"})
    public Response getKudosBudget() {
        return Response.ok((Object)String.valueOf(this.extendedWalletService.getKudosBudget())).build();
    }

    @Path(value="getKudosContract")
    @GET
    @RolesAllowed(value={"administrators"})
    public Response getKudosContract() {
        return Response.ok((Object)String.valueOf(this.extendedWalletService.getKudosContract())).build();
    }

    @POST
    @Path(value="saveKudosTotalBudget")
    @RolesAllowed(value={"administrators"})
    public Response saveKudosTotalBudget(@FormParam(value="budget") double budget) {
        this.extendedWalletService.saveKudosTotalBudget(budget);
        LOG.info("{} saved kudos total budget '{}'", new Object[]{Utils.getCurrentUserId(), budget});
        return Response.ok().build();
    }

    @POST
    @Path(value="saveKudosContract")
    @RolesAllowed(value={"administrators"})
    public Response saveKudosContract(@FormParam(value="kudosContract") String kudosContractAddress) {
        this.extendedWalletService.saveKudosContract(kudosContractAddress);
        LOG.info("{} saved kudos contract '{}'", new Object[]{Utils.getCurrentUserId(), kudosContractAddress});
        return Response.ok().build();
    }
}

