/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.hibernate.annotations.DynamicUpdate;

@Entity(name="WalletTransaction")
@ExoEntity
@DynamicUpdate
@Table(name="ADDONS_WALLET_TRANSACTION")
@NamedQueries(value={@NamedQuery(name="WalletTransaction.getContractTransactions", query="SELECT tx FROM WalletTransaction tx WHERE tx.networkId = :networkId AND tx.contractAddress = :contractAddress ORDER BY tx.createdDate DESC"), @NamedQuery(name="WalletTransaction.getWalletTransactions", query="SELECT tx FROM WalletTransaction tx WHERE tx.networkId = :networkId AND ADMIN_OP = FALSE AND (tx.fromAddress = :address OR tx.toAddress = :address OR tx.byAddress = :address) ORDER BY tx.createdDate DESC"), @NamedQuery(name="WalletTransaction.getAllWalletTransactions", query="SELECT tx FROM WalletTransaction tx WHERE tx.networkId = :networkId AND (tx.fromAddress = :address OR tx.toAddress = :address OR tx.byAddress = :address) ORDER BY tx.createdDate DESC"), @NamedQuery(name="WalletTransaction.getPendingTransactions", query="SELECT tx FROM WalletTransaction tx WHERE tx.isPending = TRUE"), @NamedQuery(name="WalletTransaction.getTransactionByHash", query="SELECT tx FROM WalletTransaction tx WHERE tx.hash = :hash")})
public class TransactionEntity
implements Serializable {
    private static final long serialVersionUID = 485850826850947238L;
    @Id
    @SequenceGenerator(name="SEQ_WALLET_TRANSACTION", sequenceName="SEQ_WALLET_TRANSACTION")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WALLET_TRANSACTION")
    @Column(name="TRANSACTION_ID")
    private long id;
    @Column(name="NETWORK_ID", nullable=false)
    private long networkId;
    @Column(name="HASH", unique=true, nullable=false)
    private String hash;
    @Column(name="PENDING")
    private boolean isPending;
    @Column(name="SUCCESS")
    private boolean isSuccess;
    @Column(name="ADMIN_OP")
    private boolean isAdminOperation;
    @Column(name="FROM_ADDRESS", nullable=false)
    private String fromAddress;
    @Column(name="TO_ADDRESS")
    private String toAddress;
    @Column(name="BY_ADDRESS")
    private String byAddress;
    @Column(name="LABEL")
    private String label;
    @Column(name="MESSAGE")
    private String message;
    @Column(name="VALUE")
    private double value;
    @Column(name="CONTRACT_ADDRESS")
    private String contractAddress;
    @Column(name="CONTRACT_METHOD")
    private String contractMethodName;
    @Column(name="CONTRACT_AMOUNT")
    private double contractAmount;
    @Column(name="CREATED_DATE")
    private long createdDate;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(long networkId) {
        this.networkId = networkId;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public void setPending(boolean isPending) {
        this.isPending = isPending;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public boolean isAdminOperation() {
        return this.isAdminOperation;
    }

    public void setAdminOperation(boolean isAdminOperation) {
        this.isAdminOperation = isAdminOperation;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public String getByAddress() {
        return this.byAddress;
    }

    public void setByAddress(String byAddress) {
        this.byAddress = byAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractMethodName() {
        return this.contractMethodName;
    }

    public void setContractMethodName(String contractMethodName) {
        this.contractMethodName = contractMethodName;
    }

    public double getContractAmount() {
        return this.contractAmount;
    }

    public void setContractAmount(double contractAmount) {
        this.contractAmount = contractAmount;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(long createdDate) {
        this.createdDate = createdDate;
    }
}

