/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.listener;

import java.util.concurrent.ExecutionException;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletTransactionService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

@Asynchronous
public class EthereumTransactionProcessorListener
extends Listener<Transaction, TransactionReceipt> {
    private EthereumWalletTransactionService transactionService;
    private EthereumClientConnector ethereumClientConnector;
    private ExoContainer container;

    public EthereumTransactionProcessorListener(ExoContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Transaction, TransactionReceipt> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Transaction transaction = (Transaction)event.getSource();
            if (transaction == null) {
                return;
            }
            TransactionDetail transactionDetail = this.getTransactionService().getTransactionByHash(transaction.getHash(), true);
            if (transactionDetail == null) {
                return;
            }
            TransactionReceipt transactionReceipt = null;
            try {
                transactionReceipt = this.getTransactionStatus(transaction);
            }
            catch (Exception e) {
                transactionReceipt = this.getTransactionStatus(transaction);
            }
            transactionDetail.setPending(false);
            transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
            this.getTransactionService().saveTransactionDetail(transactionDetail, null, true);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private TransactionReceipt getTransactionStatus(Transaction transaction) throws InterruptedException, ExecutionException {
        TransactionReceipt transactionReceipt = this.getEthereumClientConnector().getTransactionReceipt(transaction.getHash());
        if (transactionReceipt == null || "0x0".equals(transactionReceipt.getStatus())) {
            return null;
        }
        return transactionReceipt;
    }

    private EthereumClientConnector getEthereumClientConnector() {
        if (this.ethereumClientConnector == null) {
            this.ethereumClientConnector = (EthereumClientConnector)CommonsUtils.getService(EthereumClientConnector.class);
        }
        return this.ethereumClientConnector;
    }

    private EthereumWalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (EthereumWalletTransactionService)CommonsUtils.getService(EthereumWalletTransactionService.class);
        }
        return this.transactionService;
    }
}

