/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.storage;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.addon.ethereum.wallet.dao.WalletAccountDAO;
import org.exoplatform.addon.ethereum.wallet.entity.WalletEntity;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletType;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;

public class AccountStorage {
    private WalletAccountDAO walletAccountDAO;

    public AccountStorage(WalletAccountDAO walletAccountDAO) {
        this.walletAccountDAO = walletAccountDAO;
    }

    public Set<Wallet> listWallets() {
        List walletEntities = this.walletAccountDAO.findAll();
        if (walletEntities == null || walletEntities.isEmpty()) {
            return Collections.emptySet();
        }
        return walletEntities.stream().map(this::fromEntity).collect(Collectors.toSet());
    }

    public long getWalletsCount() {
        return this.walletAccountDAO.count();
    }

    public Wallet getWalletByIdentityId(long identityId) {
        WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(identityId));
        if (walletEntity == null) {
            return null;
        }
        return this.fromEntity(walletEntity);
    }

    public Wallet getWalletByAddress(String address) {
        WalletEntity walletEntity = this.walletAccountDAO.findByAddress(address.toLowerCase());
        if (walletEntity == null) {
            return null;
        }
        return this.fromEntity(walletEntity);
    }

    public void saveWallet(Wallet wallet, boolean isNew) {
        WalletEntity walletEntity = this.toEntity(wallet);
        if (isNew) {
            this.walletAccountDAO.create(walletEntity);
        } else {
            this.walletAccountDAO.update(walletEntity);
        }
    }

    public Wallet removeWallet(long identityId) {
        WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(identityId));
        this.walletAccountDAO.delete(walletEntity);
        return this.fromEntity(walletEntity);
    }

    private Wallet fromEntity(WalletEntity walletEntity) {
        Wallet wallet = new Wallet();
        wallet.setTechnicalId(walletEntity.getId());
        wallet.setEnabled(walletEntity.isEnabled());
        wallet.setAddress(walletEntity.getAddress());
        wallet.setPassPhrase(walletEntity.getPassPhrase());
        Identity identity = Utils.getIdentityById(walletEntity.getId());
        if (wallet.isEnabled()) {
            wallet.setEnabled(identity.isEnable() && !identity.isDeleted());
        }
        WalletType type = walletEntity.getType();
        wallet.setType(type.getId());
        if (type.isUser()) {
            wallet.setName(identity.getProfile().getFullName());
        } else {
            Space space = Utils.getSpace(identity.getRemoteId());
            wallet.setName(space.getDisplayName());
            wallet.setSpaceId(Long.parseLong(space.getId()));
        }
        wallet.setId(identity.getRemoteId());
        wallet.setAvatar(LinkProvider.buildAvatarURL((String)identity.getProviderId(), (String)identity.getRemoteId()));
        return wallet;
    }

    private WalletEntity toEntity(Wallet wallet) {
        WalletEntity walletEntity = new WalletEntity();
        walletEntity.setId(wallet.getTechnicalId());
        walletEntity.setAddress(wallet.getAddress().toLowerCase());
        walletEntity.setEnabled(wallet.isEnabled());
        walletEntity.setPassPhrase(wallet.getPassPhrase());
        walletEntity.setType(WalletType.getType(wallet.getType()));
        return walletEntity;
    }
}

