/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service.utils;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.TransactionStatus;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletType;
import org.exoplatform.addon.ethereum.wallet.service.utils.FakeHTTPServletRequest;
import org.exoplatform.addon.ethereum.wallet.service.utils.FakeHTTPServletResponse;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.generated.Uint256;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    public static final char[] SIMPLE_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final String EMPTY_HASH = "0x0000000000000000000000000000000000000000000000000000000000000000";
    public static final String DEFAULT_NETWORK_ID = "defaultNetworkId";
    public static final String DEFAULT_NETWORK_URL = "defaultNetworkURL";
    public static final String DEFAULT_NETWORK_WS_URL = "defaultNetworkWSURL";
    public static final String DEFAULT_ACCESS_PERMISSION = "defaultAccessPermission";
    public static final String DEFAULT_GAS = "defaultGas";
    public static final String MIN_GAS_PRICE = "minGasPrice";
    public static final String NORMAL_GAS_PRICE = "normalGasPrice";
    public static final String MAX_GAS_PRICE = "maxGasPrice";
    public static final String DEFAULT_CONTRACTS_ADDRESSES = "defaultContractAddresses";
    public static final String SCOPE_NAME = "ADDONS_ETHEREUM_WALLET";
    public static final String EXT_SCOPE_NAME = "ADDONS_ETHEREUM_WALLET_EXT";
    public static final String GLOBAL_SETTINGS_KEY_NAME = "GLOBAL_SETTINGS";
    public static final String EXT_GAMIFICATION_SETTINGS_KEY_NAME = "GAMIFICATION_SETTINGS";
    public static final String EXT_TOKENS_KUDOS_BUDGET = "KUDOS_BUDGET";
    public static final String EXT_KUDOS_CONTRACT_ADDRESS_KEY_NAME = "KUDOS_CONTRACT_ADDRESS";
    public static final String ADDRESS_KEY_NAME = "ADDONS_ETHEREUM_WALLET_ADDRESS";
    public static final String LAST_BLOCK_NUMBER_KEY_NAME = "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER";
    public static final String SETTINGS_KEY_NAME = "ADDONS_ETHEREUM_WALLET_SETTINGS";
    public static final Context WALLET_CONTEXT = Context.GLOBAL;
    public static final Context EXT_WALLET_CONTEXT = Context.GLOBAL;
    public static final Scope WALLET_SCOPE = Scope.APPLICATION.id("ADDONS_ETHEREUM_WALLET");
    public static final Scope EXT_WALLET_SCOPE = Scope.APPLICATION.id("ADDONS_ETHEREUM_WALLET_EXT");
    public static final String WALLET_DEFAULT_CONTRACTS_NAME = "WALLET_DEFAULT_CONTRACTS";
    public static final String WALLET_USER_TRANSACTION_NAME = "WALLET_USER_TRANSACTION";
    public static final String WALLET_BROWSER_PHRASE_NAME = "WALLET_BROWSER_PHRASE";
    public static final String ABI_PATH_PARAMETER = "contract.abi.path";
    public static final String BIN_PATH_PARAMETER = "contract.bin.path";
    public static final int GLOBAL_DATA_VERSION = 2;
    public static final int USER_DATA_VERSION = 1;
    public static final int DEFAULT_GAS_UPGRADE_VERSION = 1;
    public static final int DEFAULT_GAS_PRICE_UPGRADE_VERSION = 1;
    public static final String ADMINISTRATORS_GROUP = "/platform/administrators";
    public static final String GLOAL_SETTINGS_CHANGED_EVENT = "exo.addon.wallet.settings.changed";
    public static final String NEW_ADDRESS_ASSOCIATED_EVENT = "exo.addon.wallet.addressAssociation.new";
    public static final String MODIFY_ADDRESS_ASSOCIATED_EVENT = "exo.addon.wallet.addressAssociation.modification";
    public static final String KNOWN_TRANSACTION_MINED_EVENT = "exo.addon.wallet.transaction.mined";
    public static final String UPGRADE_NOTIFICATION_SETTINGS = "exo.addon.wallet.notification.upgrade";
    public static final String NEW_TRANSACTION_EVENT = "exo.addon.wallet.transaction.loaded";
    public static final String NEW_BLOCK_EVENT = "exo.addon.wallet.block.loaded";
    public static final String WALLET_SENDER_NOTIFICATION_ID = "EtherSenderNotificationPlugin";
    public static final String WALLET_RECEIVER_NOTIFICATION_ID = "EtherReceiverNotificationPlugin";
    public static final String FUNDS_REQUEST_NOTIFICATION_ID = "FundsRequestNotificationPlugin";
    public static final String FUNDS_REQUEST_SENT = "sent";
    public static final String CONTRACT_ADDRESS = "contractAddress";
    public static final String AMOUNT = "amount";
    public static final String SYMBOL = "symbol";
    public static final String MESSAGE = "message";
    public static final String HASH = "hash";
    public static final String ACCOUNT_TYPE = "account_type";
    public static final String RECEIVER_TYPE = "receiver_type";
    public static final String AVATAR = "avatar";
    public static final String SENDER = "sender";
    public static final String USER = "userFullname";
    public static final String USER_URL = "userUrl";
    public static final String SENDER_URL = "senderUrl";
    public static final String RECEIVER = "receiver";
    public static final String RECEIVER_URL = "receiverUrl";
    public static final String FUNDS_ACCEPT_URL = "fundsAcceptUrl";
    public static final ArgumentLiteral<Wallet> FUNDS_REQUEST_SENDER_DETAIL_PARAMETER = new ArgumentLiteral(Wallet.class, "senderFullName");
    public static final ArgumentLiteral<Wallet> SENDER_ACCOUNT_DETAIL_PARAMETER = new ArgumentLiteral(Wallet.class, "senderAccountDetail");
    public static final ArgumentLiteral<Wallet> RECEIVER_ACCOUNT_DETAIL_PARAMETER = new ArgumentLiteral(Wallet.class, "receiverAccountDetail");
    public static final ArgumentLiteral<FundsRequest> FUNDS_REQUEST_PARAMETER = new ArgumentLiteral(FundsRequest.class, "fundsRequest");
    public static final ArgumentLiteral<TransactionStatus> TRANSACTION_STATUS_PARAMETER = new ArgumentLiteral(TransactionStatus.class, "transactionStatus");
    public static final ArgumentLiteral<ContractDetail> CONTRACT_DETAILS_PARAMETER = new ArgumentLiteral(ContractDetail.class, "contractDetails");
    public static final ArgumentLiteral<Double> AMOUNT_PARAMETER = new ArgumentLiteral(Double.class, "amount");
    public static final ArgumentLiteral<String> MESSAGE_PARAMETER = new ArgumentLiteral(String.class, "message");
    public static final ArgumentLiteral<String> HASH_PARAMETER = new ArgumentLiteral(String.class, "hash");
    public static final ArgumentLiteral<String> SYMBOL_PARAMETER = new ArgumentLiteral(String.class, "symbol");
    public static final ArgumentLiteral<String> CONTRACT_ADDRESS_PARAMETER = new ArgumentLiteral(String.class, "contractAddress");

    private Utils() {
    }

    public static final String getCurrentUserId() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null) {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        return null;
    }

    public static Event approvalEvent() {
        return new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    }

    public static List<String> getNotificationReceiversUsers(Wallet toAccount, String excludedId) {
        if (WalletType.isSpace(toAccount.getType())) {
            Space space = Utils.getSpace(toAccount.getId());
            if (space == null) {
                return Collections.singletonList(toAccount.getId());
            }
            String[] members = space.getMembers();
            if (members == null || members.length == 0) {
                return Collections.emptyList();
            }
            if (StringUtils.isBlank((CharSequence)excludedId)) {
                return Arrays.asList(members);
            }
            return Arrays.stream(members).filter(member -> !excludedId.equals(member)).collect(Collectors.toList());
        }
        return Collections.singletonList(toAccount.getId());
    }

    public static String getPermanentLink(Wallet account) {
        String profileLink = null;
        try {
            profileLink = account.getId() == null || account.getType() == null ? account.getName() : (WalletType.isUser(account.getType()) ? LinkProvider.getProfileLink((String)account.getId()) : Utils.getPermanentLink(Utils.getSpacePrettyName(account.getId()), account.getName()));
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting profile link of space", (Throwable)e);
        }
        return profileLink;
    }

    public static org.exoplatform.social.core.identity.model.Identity getIdentityById(long identityId) {
        return Utils.getIdentityById(String.valueOf(identityId));
    }

    public static org.exoplatform.social.core.identity.model.Identity getIdentityById(String identityId) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return identityManager.getIdentity(identityId, true);
    }

    public static org.exoplatform.social.core.identity.model.Identity getIdentityByTypeAndId(WalletType type, String remoteId) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        return identityManager.getOrCreateIdentity(type.getProviderId(), remoteId, true);
    }

    public static String getSpacePrettyName(String id) {
        Space space = Utils.getSpace(id);
        return space == null ? id : space.getPrettyName();
    }

    public static Space getSpace(String id) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        if (id.indexOf("/spaces/") >= 0) {
            return spaceService.getSpaceByGroupId(id);
        }
        Space space = spaceService.getSpaceByPrettyName(id);
        if (space == null && (space = spaceService.getSpaceByGroupId("/spaces/" + id)) == null && (space = spaceService.getSpaceByDisplayName(id)) == null && (space = spaceService.getSpaceByUrl(id)) == null) {
            space = spaceService.getSpaceById(id);
        }
        return space;
    }

    public static void computeWalletIdentity(Wallet wallet) {
        if (wallet.getTechnicalId() == 0L) {
            org.exoplatform.social.core.identity.model.Identity identity;
            String remoteId = wallet.getId();
            if (StringUtils.isBlank((CharSequence)remoteId)) {
                throw new IllegalStateException("Wallet identityId and remoteId are empty, thus it can't be saved");
            }
            WalletType type = WalletType.getType(wallet.getType());
            if (type.isSpace()) {
                remoteId = Utils.getSpacePrettyName(remoteId);
                wallet.setId(remoteId);
            }
            if ((identity = Utils.getIdentityByTypeAndId(type, remoteId)) == null) {
                throw new IllegalStateException("Can't find identity with id " + remoteId + " and type " + (Object)((Object)type));
            }
            wallet.setType(type.getId());
            wallet.setId(identity.getRemoteId());
            wallet.setTechnicalId(Long.parseLong(identity.getId()));
        } else {
            org.exoplatform.social.core.identity.model.Identity identity = Utils.getIdentityById(wallet.getTechnicalId());
            if (identity == null) {
                throw new IllegalStateException("Can't find identity with identity id " + wallet.getTechnicalId());
            }
            WalletType type = WalletType.getType(identity.getProviderId());
            wallet.setType(type.getId());
            wallet.setId(identity.getRemoteId());
        }
    }

    public static final boolean isUserAdmin(String username) {
        return Utils.isUserMemberOf(username, ADMINISTRATORS_GROUP);
    }

    public static final boolean isUserMemberOf(String username, String permissionExpression) {
        if (StringUtils.isBlank((CharSequence)permissionExpression)) {
            throw new IllegalArgumentException("Permission expression is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        if (permissionExpression.contains(":")) {
            throw new UnsupportedOperationException("Permission check with role/membershipType isn't implemented ");
        }
        if (permissionExpression.contains("/")) {
            Collection groupsOfUser;
            Identity identity = ((IdentityRegistry)CommonsUtils.getService(IdentityRegistry.class)).getIdentity(username);
            if (identity != null) {
                return identity.isMemberOf(permissionExpression);
            }
            try {
                groupsOfUser = ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getGroupHandler().findGroupsOfUser(username);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error getting groups of user " + username));
                return false;
            }
            if (groupsOfUser == null || groupsOfUser.isEmpty()) {
                return false;
            }
            for (Group group : groupsOfUser) {
                if (!permissionExpression.equals(group.getId())) continue;
                return true;
            }
            return false;
        }
        return StringUtils.equals((CharSequence)username, (CharSequence)permissionExpression);
    }

    public static String getWalletLink(String receiverType, String receiverId) {
        if (receiverType == null || receiverId == null || WalletType.isUser(receiverType)) {
            return CommonsUtils.getCurrentDomain() + Utils.getMyWalletLink();
        }
        Space space = Utils.getSpace(receiverId);
        if (space == null) {
            return CommonsUtils.getCurrentDomain() + Utils.getMyWalletLink();
        }
        return CommonsUtils.getCurrentDomain() + LinkProvider.getSpaceUri((String)space.getPrettyName()) + "/EthereumSpaceWallet";
    }

    public static String getMyWalletLink() {
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)CommonsUtils.getService(UserPortalConfigService.class);
        return "/" + PortalContainer.getInstance().getName() + "/" + userPortalConfigService.getDefaultPortal() + "/wallet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPermanentLink(String prettyName, String name) {
        WebAppController webAppController = (WebAppController)CommonsUtils.getService(WebAppController.class);
        ControllerContext controllerContext = new ControllerContext(webAppController, webAppController.getRouter(), (HttpServletRequest)new FakeHTTPServletResponse(), (HttpServletResponse)new FakeHTTPServletRequest(), null);
        PortalApplication application = (PortalApplication)webAppController.getApplication("PortalApplication");
        PortalRequestContext requestContext = new PortalRequestContext((WebuiApplication)application, controllerContext, SiteType.PORTAL.toString(), "", "", null);
        WebuiRequestContext.setCurrentInstance((RequestContext)requestContext);
        try {
            String spaceUrl = LinkProvider.getSpaceUri((String)prettyName);
            if (StringUtils.isBlank((CharSequence)spaceUrl)) {
                String string = CommonsUtils.getCurrentDomain();
                return string;
            }
            spaceUrl = CommonsUtils.getCurrentDomain() + spaceUrl;
            String string = "<a href=\"" + spaceUrl + "\" target=\"_parent\">" + StringEscapeUtils.escapeHtml((String)name) + "</a>";
            return string;
        }
        finally {
            WebuiRequestContext.setCurrentInstance(null);
        }
    }

    public static Set<String> jsonArrayToList(JSONObject jsonObject, String key) throws JSONException {
        HashSet<String> set = null;
        if (jsonObject.has(key)) {
            set = new HashSet<String>();
            JSONArray arrayValue = jsonObject.getJSONArray(key);
            for (int i = 0; i < arrayValue.length(); ++i) {
                set.add(arrayValue.getString(i));
            }
        }
        return set;
    }

    public static String encodeString(String content) {
        try {
            return StringUtils.isBlank((CharSequence)content) ? "" : URLEncoder.encode(content.trim(), "UTF-8");
        }
        catch (Exception e) {
            return content;
        }
    }

    public static String decodeString(String content) {
        try {
            return StringUtils.isBlank((CharSequence)content) ? "" : URLDecoder.decode(content.trim(), "UTF-8");
        }
        catch (Exception e) {
            return content;
        }
    }

    public static boolean isUserSpaceManager(String id, String modifier) {
        try {
            return Utils.checkUserIsSpaceManager(id, modifier, false);
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public static boolean isUserSpaceMember(String spaceId, String accesssor) {
        Space space = Utils.getSpace(spaceId);
        if (space == null) {
            LOG.warn("Space not found with id '{}'", new Object[]{spaceId});
            throw new IllegalStateException("Space not found with id '" + spaceId + "'");
        }
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        return spaceService.isSuperManager(accesssor) || spaceService.isMember(space, accesssor) || spaceService.isManager(space, accesssor);
    }

    public static boolean checkUserIsSpaceManager(String spaceId, String modifier, boolean throwException) throws IllegalAccessException {
        Space space = Utils.getSpace(spaceId);
        if (space == null) {
            LOG.warn("Space not found with id '{}'", new Object[]{spaceId});
            throw new IllegalStateException();
        }
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        if (!spaceService.isManager(space, modifier) && !spaceService.isSuperManager(modifier)) {
            if (throwException) {
                LOG.error("User '{}' attempts to modify wallet address of space '{}'", new Object[]{modifier, space.getDisplayName()});
                throw new IllegalAccessException();
            }
            return false;
        }
        return true;
    }

    public static final void computeWalletFromIdentity(Wallet wallet, org.exoplatform.social.core.identity.model.Identity identity) {
        WalletType walletType = WalletType.getType(identity.getProviderId());
        wallet.setId(identity.getRemoteId());
        wallet.setTechnicalId(Long.parseLong(identity.getId()));
        wallet.setEnabled(identity.isEnable() && !identity.isDeleted());
        wallet.setDisabledUser(!identity.isEnable());
        wallet.setDeletedUser(identity.isDeleted());
        wallet.setType(walletType.getId());
        wallet.setAvatar(LinkProvider.buildAvatarURL((String)identity.getProviderId(), (String)identity.getRemoteId()));
        if (walletType.isUser()) {
            wallet.setName(identity.getProfile().getFullName());
        } else {
            Space space = Utils.getSpace(identity.getRemoteId());
            wallet.setName(space.getDisplayName());
            wallet.setSpaceId(Long.parseLong(space.getId()));
        }
    }
}

