/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.reward.model;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardPeriod;
import org.exoplatform.addon.ethereum.wallet.reward.service.utils.RewardUtils;

public enum RewardPeriodType {
    WEEK,
    MONTH,
    QUARTER,
    SEMESTER,
    YEAR;

    public static final RewardPeriodType DEFAULT;

    public RewardPeriod getPeriodOfTime(LocalDateTime localDateTime) {
        RewardPeriod rewardPeriod = new RewardPeriod();
        YearMonth yearMonth = YearMonth.from(localDateTime);
        switch (this) {
            case WEEK: {
                LocalDateTime firstDayOfThisWeek = localDateTime.with(DayOfWeek.MONDAY);
                LocalDateTime firstDayOfNextWeek = firstDayOfThisWeek.plusWeeks(1L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSeconds(firstDayOfThisWeek));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSeconds(firstDayOfNextWeek));
                break;
            }
            case MONTH: {
                YearMonth currentMonth = yearMonth;
                YearMonth nextMonth = currentMonth.plusMonths(1L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSeconds(currentMonth.atDay(1).atStartOfDay()));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSeconds(nextMonth.atDay(1).atStartOfDay()));
                break;
            }
            case QUARTER: {
                int monthQuarterIndex = (yearMonth.getMonthValue() - 1) / 3 * 3 + 1;
                YearMonth startQuarterMonth = YearMonth.of(yearMonth.getYear(), monthQuarterIndex);
                YearMonth endQuarterMonth = startQuarterMonth.plusMonths(3L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSeconds(startQuarterMonth.atDay(1).atStartOfDay()));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSeconds(endQuarterMonth.atDay(1).atStartOfDay()));
                break;
            }
            case SEMESTER: {
                int monthSemesterIndex = (yearMonth.getMonthValue() - 1) / 6 * 6 + 1;
                YearMonth startSemesterMonth = YearMonth.of(yearMonth.getYear(), monthSemesterIndex);
                YearMonth endSemesterMonth = startSemesterMonth.plusMonths(6L);
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSeconds(startSemesterMonth.atDay(1).atStartOfDay()));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSeconds(endSemesterMonth.atDay(1).atStartOfDay()));
                break;
            }
            case YEAR: {
                rewardPeriod.setStartDateInSeconds(RewardUtils.timeToSeconds(Year.from(localDateTime).atDay(1).atStartOfDay()));
                rewardPeriod.setEndDateInSeconds(RewardUtils.timeToSeconds(Year.from(localDateTime).plusYears(1L).atDay(1).atStartOfDay()));
            }
        }
        return rewardPeriod;
    }

    static {
        DEFAULT = MONTH;
    }
}

