/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.reward.service.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.reward.entity.RewardTeamEntity;
import org.exoplatform.addon.ethereum.wallet.reward.entity.RewardTeamMemberEntity;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardTeam;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardTeamMember;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.json.JsonGenerator;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.JsonParser;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class RewardUtils {
    public static final JsonParser JSON_PARSER = new JsonParserImpl();
    public static final JsonGenerator JSON_GENERATOR = new JsonGeneratorImpl();
    public static final String REWARD_SCOPE_NAME = "ADDONS_REWARD";
    public static final String REWARD_CONTEXT_NAME = "ADDONS_REWARD";
    public static final Context REWARD_CONTEXT = Context.GLOBAL.id("ADDONS_REWARD");
    public static final Scope REWARD_SCOPE = Scope.APPLICATION.id("ADDONS_REWARD");
    public static final String REWARD_SETTINGS_KEY_NAME = "REWARD_SETTINGS";

    private RewardUtils() {
    }

    public static LocalDateTime timeFromSeconds(long createdDate) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(createdDate), TimeZone.getDefault().toZoneId());
    }

    public static long timeToSeconds(LocalDateTime time) {
        return time.atZone(ZoneOffset.systemDefault()).toEpochSecond();
    }

    public static RewardTeamEntity fromDTO(RewardTeam rewardTeam) {
        if (rewardTeam == null) {
            return null;
        }
        RewardTeamEntity teamEntity = new RewardTeamEntity();
        teamEntity.setId(rewardTeam.getId() == null || rewardTeam.getId() == 0L ? null : rewardTeam.getId());
        teamEntity.setName(rewardTeam.getName());
        teamEntity.setDescription(rewardTeam.getDescription());
        teamEntity.setBudget(rewardTeam.getBudget());
        teamEntity.setRewardType(rewardTeam.getRewardType());
        teamEntity.setRewardPerMember(rewardTeam.getRewardPerMember());
        teamEntity.setDisabled(rewardTeam.isDisabled());
        if (rewardTeam.getManager() != null && rewardTeam.getManager().getIdentityId() != 0L) {
            teamEntity.setManager(rewardTeam.getManager().getIdentityId());
        }
        if (rewardTeam.getSpaceId() != null && rewardTeam.getSpaceId() != 0L) {
            teamEntity.setSpaceId(rewardTeam.getSpaceId());
        }
        if (rewardTeam.getMembers() != null && !rewardTeam.getMembers().isEmpty()) {
            teamEntity.setMembers(rewardTeam.getMembers().stream().map(rewardTeamMember -> RewardUtils.getRewardTeamMemberEntity(teamEntity, rewardTeamMember)).collect(Collectors.toSet()));
        }
        return teamEntity;
    }

    public static RewardTeam toDTO(RewardTeamEntity teamEntity) {
        SpaceService spaceService;
        Space space;
        if (teamEntity == null) {
            return null;
        }
        RewardTeam rewardTeam = new RewardTeam();
        rewardTeam.setId(teamEntity.getId());
        rewardTeam.setName(teamEntity.getName());
        rewardTeam.setDescription(teamEntity.getDescription());
        rewardTeam.setBudget(teamEntity.getBudget());
        rewardTeam.setManager(RewardUtils.getRewardTeamMember(teamEntity.getManager()));
        rewardTeam.setRewardType(teamEntity.getRewardType());
        rewardTeam.setRewardPerMember(teamEntity.getRewardPerMember());
        rewardTeam.setDisabled(teamEntity.getDisabled());
        if (teamEntity.getSpaceId() != null && teamEntity.getSpaceId() != 0L && (space = (spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class)).getSpaceById(String.valueOf(teamEntity.getSpaceId()))) != null) {
            rewardTeam.setSpaceId(teamEntity.getSpaceId());
            rewardTeam.setSpacePrettyName(space.getPrettyName());
        }
        if (teamEntity.getMembers() != null && !teamEntity.getMembers().isEmpty()) {
            List list = teamEntity.getMembers().stream().map(teamMemberEntity -> RewardUtils.getRewardTeamMember(teamMemberEntity)).collect(Collectors.toList());
            rewardTeam.setMembers(new ArrayList<RewardTeamMember>(list));
        }
        return rewardTeam;
    }

    private static RewardTeamMemberEntity getRewardTeamMemberEntity(RewardTeamEntity teamEntity, RewardTeamMember rewardTeamMember) {
        if (rewardTeamMember == null) {
            return null;
        }
        RewardTeamMemberEntity teamMemberEntity = new RewardTeamMemberEntity();
        teamMemberEntity.setId(rewardTeamMember.getTechnicalId() == null || rewardTeamMember.getTechnicalId() == 0L ? null : rewardTeamMember.getTechnicalId());
        teamMemberEntity.setIdentityId(rewardTeamMember.getIdentityId());
        teamMemberEntity.setTeam(teamEntity);
        return teamMemberEntity;
    }

    private static RewardTeamMember getRewardTeamMember(RewardTeamMemberEntity teamMemberEntity) {
        if (teamMemberEntity == null) {
            return null;
        }
        RewardTeamMember rewardTeamMember = RewardUtils.getRewardTeamMember(teamMemberEntity.getIdentityId());
        if (rewardTeamMember == null) {
            return null;
        }
        rewardTeamMember.setTechnicalId(teamMemberEntity.getId());
        return rewardTeamMember;
    }

    private static RewardTeamMember getRewardTeamMember(Long identityId) {
        if (identityId == null || identityId == 0L) {
            return null;
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getIdentity(String.valueOf(identityId), true);
        if (identity == null) {
            return null;
        }
        RewardTeamMember rewardTeamMember = new RewardTeamMember();
        rewardTeamMember.setId(identity.getRemoteId());
        rewardTeamMember.setProviderId(identity.getProviderId());
        rewardTeamMember.setIdentityId(Long.parseLong(identity.getId()));
        return rewardTeamMember;
    }

    public static String decodeString(String content) {
        try {
            return StringUtils.isBlank((String)content) ? "" : URLDecoder.decode(content.trim(), "UTF-8");
        }
        catch (Exception e) {
            return content;
        }
    }

    public static String encodeString(String content) {
        try {
            return StringUtils.isBlank((String)content) ? "" : URLEncoder.encode(content.trim(), "UTF-8");
        }
        catch (Exception e) {
            return content;
        }
    }

    public static final <T> T fromJsonString(String value, Class<T> resultClass) throws JsonException {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
        JSON_PARSER.parse((InputStream)new ByteArrayInputStream(value.getBytes()), (JsonHandler)jsonDefaultHandler);
        return (T)ObjectBuilder.createObject(resultClass, (JsonValue)jsonDefaultHandler.getJsonObject());
    }

    public static final String toJsonString(Object object) throws JsonException {
        return JSON_GENERATOR.createJsonObject(object).toString();
    }

    public static final String getCurrentUserId() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null) {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        return null;
    }

    public static final Method getMethod(ExoContainer container, String serviceName, String methodName) {
        Object serviceInstance = RewardUtils.getService(container, serviceName);
        if (serviceInstance == null) {
            return null;
        }
        Method methodResult = null;
        int i = 0;
        Method[] declaredMethods = serviceInstance.getClass().getDeclaredMethods();
        while (methodResult == null && i < declaredMethods.length) {
            Method method;
            if (!(method = declaredMethods[i++]).getName().equals(methodName)) continue;
            methodResult = method;
        }
        return methodResult;
    }

    public static final Object getService(ExoContainer container, String serviceName) {
        Object serviceInstance = null;
        try {
            serviceInstance = container.getComponentInstanceOfType(Class.forName(serviceName));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return serviceInstance;
    }
}

