/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.task.rest;

import java.util.Collections;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.ethereum.wallet.task.model.WalletAdminTask;
import org.exoplatform.addon.ethereum.wallet.task.service.WalletTaskService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/wallet/api/task")
@RolesAllowed(value={"users"})
public class WalletTaskREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletTaskREST.class);
    private WalletTaskService walletTaskService;

    public WalletTaskREST(WalletTaskService walletTaskService) {
        this.walletTaskService = walletTaskService;
    }

    @GET
    @Path(value="list")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response listTasks() {
        ConversationState currentState = ConversationState.getCurrent();
        if (currentState == null || currentState.getIdentity() == null || currentState.getIdentity().getUserId() == null || currentState.getIdentity().getRoles() == null || !currentState.getIdentity().getRoles().contains("rewarding")) {
            return Response.ok(Collections.emptyList()).build();
        }
        try {
            Set<WalletAdminTask> tasks = this.walletTaskService.listTasks(currentState.getIdentity().getUserId());
            return Response.ok(tasks).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting listing tasks", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append("error", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }

    @GET
    @Path(value="markCompleted")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    public Response markCompleted(@QueryParam(value="taskId") long taskId) {
        try {
            this.walletTaskService.markCompleted(taskId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.warn("Error marking task with id {} as completed", new Object[]{taskId, e});
            JSONObject object = new JSONObject();
            try {
                object.append("error", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }
}

