/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.task.listener;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.task.model.WalletAdminTask;
import org.exoplatform.addon.ethereum.wallet.task.service.WalletTaskService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Asynchronous
public class WalletAddressListener
extends Listener<Wallet, Wallet> {
    private static final Log LOG = ExoLogger.getLogger(WalletAddressListener.class);
    private static final String WALLET_TASK_ADDRESS_PARAMETER_PREFIX = "address:";
    private PortalContainer container;
    private WalletTaskService walletTaskService;

    public WalletAddressListener(PortalContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Wallet, Wallet> event) throws Exception {
        Wallet wallet = (Wallet)event.getData();
        String addressParameter = WALLET_TASK_ADDRESS_PARAMETER_PREFIX + StringUtils.lowerCase((String)wallet.getAddress());
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            ArrayList<String> parameters;
            String taskType = StringUtils.equals((String)event.getEventName(), (String)"exo.addon.wallet.addressAssociation.new") ? "new-wallet" : "modify-wallet";
            Set adminTasks = this.getWalletTaskService().getTasksByType(taskType);
            WalletAdminTask adminTask = null;
            if (adminTasks != null && !adminTasks.isEmpty()) {
                adminTask = (WalletAdminTask)adminTasks.iterator().next();
                if (adminTasks.size() > 1) {
                    LOG.warn("More than one task for type {} is retrieved from database", new Object[]{taskType});
                }
            }
            if (adminTask == null) {
                adminTask = new WalletAdminTask();
                adminTask.setType(taskType);
            }
            if ((parameters = adminTask.getParameters()) == null) {
                parameters = new ArrayList<String>();
                adminTask.setParameters(parameters);
            } else if (parameters.contains(addressParameter)) {
                return;
            }
            if (adminTask.isCompleted()) {
                parameters.clear();
            }
            adminTask.setCompleted(false);
            parameters.add(addressParameter);
            this.getWalletTaskService().save(adminTask, null);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public WalletTaskService getWalletTaskService() {
        if (this.walletTaskService == null) {
            this.walletTaskService = (WalletTaskService)CommonsUtils.getService(WalletTaskService.class);
        }
        return this.walletTaskService;
    }
}

