/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.service.WalletTransactionService;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/transaction")
@RolesAllowed(value={"users"})
public class WalletTransactionREST
implements ResourceContainer {
    private static final String EMPTY_ADDRESS_ERROR = "Bad request sent to server with empty address {}";
    private static final Log LOG = ExoLogger.getLogger(WalletTransactionREST.class);
    private WalletTransactionService transactionService;

    public WalletTransactionREST(WalletTransactionService transactionService) {
        this.transactionService = transactionService;
    }

    @POST
    @Path(value="saveTransactionDetails")
    @RolesAllowed(value={"users"})
    public Response saveTransactionDetails(TransactionDetail transactionDetail) {
        if (transactionDetail == null || StringUtils.isBlank((String)transactionDetail.getHash()) || StringUtils.isBlank((String)transactionDetail.getFrom())) {
            LOG.warn("Bad request sent to server with empty transaction details: {}", new Object[]{transactionDetail == null ? "" : transactionDetail.toString()});
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            this.transactionService.saveTransactionDetail(transactionDetail, currentUserId, false);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} is attempting to save transaction {}", new Object[]{currentUserId, transactionDetail, e});
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving transaction message", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getLastPendingTransactionSent")
    @RolesAllowed(value={"users"})
    public Response getLastPendingTransactionSent(@QueryParam(value="networkId") long networkId, @QueryParam(value="address") String address) {
        if (networkId == 0L) {
            LOG.warn("Bad request sent to server with empty networkId {}", new Object[]{networkId});
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)address)) {
            LOG.warn(EMPTY_ADDRESS_ERROR, new Object[]{address});
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            TransactionDetail transactionDetail = this.transactionService.getAddressLastPendingTransactionSent(networkId, address, currentUserId);
            return Response.ok((Object)transactionDetail).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempts to display transactions of address {}", new Object[]{currentUserId, address});
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error getting transactions of wallet " + address), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getTransactions")
    @RolesAllowed(value={"users"})
    public Response getTransactions(@QueryParam(value="networkId") long networkId, @QueryParam(value="address") String address, @QueryParam(value="contractAddress") String contractAddress, @QueryParam(value="hash") String hash, @QueryParam(value="limit") int limit, @QueryParam(value="pending") boolean onlyPending, @QueryParam(value="administration") boolean administration) {
        if (networkId == 0L) {
            LOG.warn("Bad request sent to server with empty networkId {}", new Object[]{networkId});
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)address)) {
            LOG.warn(EMPTY_ADDRESS_ERROR, new Object[]{address});
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        try {
            List<TransactionDetail> transactionDetails = this.transactionService.getTransactions(networkId, address, contractAddress, hash, limit, onlyPending, administration, currentUserId);
            return Response.ok(transactionDetails).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempts to display transactions of address {}", new Object[]{currentUserId, address});
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error getting transactions of wallet " + address), (Throwable)e);
            return Response.serverError().build();
        }
    }
}

