/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.reward.rest;

import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardPeriod;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardPeriodType;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardTransaction;
import org.exoplatform.addon.ethereum.wallet.reward.service.RewardTransactionService;
import org.exoplatform.addon.ethereum.wallet.utils.RewardUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/wallet/api/reward/transaction")
@RolesAllowed(value={"rewarding", "administrators"})
public class RewardTransactionREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardTransactionREST.class);
    private RewardTransactionService rewardTransactionService;

    public RewardTransactionREST(RewardTransactionService rewardTransactionService) {
        this.rewardTransactionService = rewardTransactionService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    @RolesAllowed(value={"rewarding", "administrators"})
    public Response getRewardTransactions(@QueryParam(value="networkId") long networkId, @QueryParam(value="periodType") String periodType, @QueryParam(value="startDateInSeconds") long startDateInSeconds) {
        if (networkId == 0L) {
            LOG.warn("Bad request sent to server with empty networkId {}", new Object[]{networkId});
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)periodType)) {
            LOG.warn("Bad request sent to server with empty periodType {}", new Object[]{periodType});
            return Response.status((int)400).build();
        }
        if (startDateInSeconds == 0L) {
            LOG.warn("Bad request sent to server with empty startDateInSeconds {}", new Object[]{startDateInSeconds});
            return Response.status((int)400).build();
        }
        List<JSONObject> periodTransactions = this.rewardTransactionService.getRewardTransactions(networkId, periodType, startDateInSeconds);
        JSONArray array = new JSONArray(periodTransactions);
        return Response.ok((Object)array.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="saveRewardTransactions")
    @RolesAllowed(value={"rewarding", "administrators"})
    public Response saveRewardTransactions(List<RewardTransaction> rewardTransactions) {
        if (rewardTransactions == null || rewardTransactions.isEmpty()) {
            LOG.warn("Bad request sent to server with empty transactions to save: {}", new Object[]{rewardTransactions});
            return Response.status((int)400).build();
        }
        try {
            for (RewardTransaction rewardTransaction : rewardTransactions) {
                this.rewardTransactionService.saveRewardTransaction(rewardTransaction);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving transaction", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="saveRewardTransaction")
    @RolesAllowed(value={"rewarding", "administrators"})
    public Response saveRewardTransaction(RewardTransaction rewardTransaction) {
        if (rewardTransaction == null) {
            LOG.warn("Bad request sent to server with empty transaction to save: {}", new Object[]{rewardTransaction});
            return Response.status((int)400).build();
        }
        try {
            this.rewardTransactionService.saveRewardTransaction(rewardTransaction);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving transaction", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @Path(value="getDates")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding", "administrators"})
    public Response getRewardDates(@QueryParam(value="periodType") String periodType, @QueryParam(value="dateInSeconds") long dateInSeconds) {
        if (dateInSeconds == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty 'dateInSeconds' parameter");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)periodType)) {
            LOG.warn((Object)"Bad request sent to server with empty 'periodType' parameter");
            return Response.status((int)400).build();
        }
        RewardPeriodType rewardPeriodType = RewardPeriodType.valueOf(periodType);
        RewardPeriod rewardPeriod = rewardPeriodType.getPeriodOfTime(RewardUtils.timeFromSeconds(dateInSeconds));
        return Response.ok((Object)rewardPeriod.toString()).build();
    }
}

