/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.listener;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Asynchronous
public class NotificationSettingsUpgradeListener
extends Listener<Object, String> {
    private static final Log LOG = ExoLogger.getLogger(NotificationSettingsUpgradeListener.class);
    private PortalContainer portalContainer;
    private WebNotificationStorage webNotificationStorage;

    public NotificationSettingsUpgradeListener(PortalContainer portalContainer, WebNotificationStorage webNotificationStorage) {
        this.webNotificationStorage = webNotificationStorage;
        this.portalContainer = portalContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Object, String> event) throws Exception {
        String notificationId = (String)event.getData();
        if (StringUtils.isBlank((String)notificationId)) {
            return;
        }
        RequestLifeCycle.begin((ExoContainer)this.portalContainer);
        try {
            NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
            if (notificationInfo != null) {
                String pluginId = notificationInfo.getKey().getId();
                if (!this.isToUpgrade(pluginId)) {
                    return;
                }
                String newPluginId = this.getNewId(pluginId);
                LOG.info("Upgrading notification plugin from {} to {} for notification with id {}", new Object[]{pluginId, newPluginId, notificationInfo.getId()});
                notificationInfo.key(PluginKey.key((String)newPluginId));
                this.webNotificationStorage.update(notificationInfo, false);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error upgrading notification plugin", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private boolean isToUpgrade(String pluginId) {
        return "ContractReceiverNotificationPlugin".equals(pluginId) || "ContractSenderNotificationPlugin".equals(pluginId);
    }

    private String getNewId(String pluginId) {
        return "ContractReceiverNotificationPlugin".equals(pluginId) ? "EtherReceiverNotificationPlugin" : "EtherSenderNotificationPlugin";
    }
}

