/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.UserPreferences;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalSettings
implements Serializable {
    private static final long serialVersionUID = -4672745644323864680L;
    private boolean walletEnabled = true;
    private boolean enableDelegation = true;
    private boolean isAdmin = false;
    private String accessPermission = null;
    private String fundsHolder = null;
    private String initialFundsRequestMessage = null;
    private String fundsHolderType = "user";
    private String providerURL = "https://ropsten.infura.io";
    private String websocketProviderURL = "wss://ropsten.infura.io/ws";
    private Integer defaultBlocksToRetrieve = 100;
    private Long defaultNetworkId = 3L;
    private Integer defaultGas = 65000;
    private String defaultPrincipalAccount = null;
    private List<String> defaultOverviewAccounts = null;
    private Map<String, Double> initialFunds;
    private UserPreferences userPreferences;
    private transient List<String> defaultContractsToDisplay;
    private transient JSONArray contractAbi = null;
    private transient String contractBin = null;

    public String toJSONString(boolean includeTransient) {
        return this.toJSONObject(includeTransient).toString();
    }

    public JSONObject toJSONObject(boolean includeTransient) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("isWalletEnabled", this.walletEnabled);
            jsonObject.put("isAdmin", this.isAdmin);
            jsonObject.put("enableDelegation", this.enableDelegation);
            jsonObject.put("accessPermission", (Object)this.accessPermission);
            jsonObject.put("initialFundsRequestMessage", (Object)this.initialFundsRequestMessage);
            jsonObject.put("fundsHolder", (Object)this.fundsHolder);
            jsonObject.put("fundsHolderType", (Object)this.fundsHolderType);
            jsonObject.put("providerURL", (Object)this.providerURL);
            jsonObject.put("websocketProviderURL", (Object)this.websocketProviderURL);
            jsonObject.put("defaultBlocksToRetrieve", (Object)this.defaultBlocksToRetrieve);
            jsonObject.put("defaultNetworkId", (Object)this.defaultNetworkId);
            jsonObject.put("defaultGas", (Object)this.defaultGas);
            if (this.initialFunds != null && !this.initialFunds.isEmpty()) {
                JSONArray array = new JSONArray();
                Set<String> addresses = this.initialFunds.keySet();
                for (String address : addresses) {
                    JSONObject obj = new JSONObject();
                    obj.put("address", (Object)address);
                    obj.put("amount", (Object)this.initialFunds.get(address));
                    array.put((Object)obj);
                }
                jsonObject.put("initialFunds", (Object)array);
            }
            if (this.userPreferences != null) {
                jsonObject.put("userPreferences", (Object)this.userPreferences.toJSONObject());
            }
            if (this.defaultPrincipalAccount != null) {
                jsonObject.put("defaultPrincipalAccount", (Object)this.defaultPrincipalAccount);
            }
            if (this.defaultOverviewAccounts != null) {
                jsonObject.put("defaultOverviewAccounts", (Object)new JSONArray(this.defaultOverviewAccounts));
            }
            if (includeTransient) {
                jsonObject.put("defaultContractsToDisplay", (Object)new JSONArray(this.defaultContractsToDisplay));
                if (this.contractAbi != null) {
                    jsonObject.put("contractAbi", (Object)this.contractAbi);
                }
                if (this.contractBin != null) {
                    jsonObject.put("contractBin", (Object)this.contractBin);
                }
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public String toString() {
        return this.toJSONString(false);
    }

    public static final GlobalSettings parseStringToObject(GlobalSettings defaultSettings, String jsonString) {
        if (defaultSettings == null) {
            defaultSettings = new GlobalSettings();
        }
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            try {
                return (GlobalSettings)defaultSettings.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            GlobalSettings globalSettings = new GlobalSettings();
            String storedFundsHolder = jsonObject.has("fundsHolder") ? jsonObject.getString("fundsHolder") : null;
            globalSettings.setFundsHolder(storedFundsHolder == null || storedFundsHolder.isEmpty() ? defaultSettings.getFundsHolder() : storedFundsHolder);
            String storedFundsHolderType = jsonObject.has("fundsHolderType") ? jsonObject.getString("fundsHolderType") : null;
            globalSettings.setFundsHolderType(storedFundsHolderType == null || storedFundsHolderType.isEmpty() ? defaultSettings.getFundsHolderType() : storedFundsHolderType);
            JSONArray storedInitialFunds = jsonObject.has("initialFunds") ? jsonObject.getJSONArray("initialFunds") : null;
            globalSettings.setInitialFunds(storedInitialFunds == null ? defaultSettings.getInitialFunds() : GlobalSettings.toMap(storedInitialFunds));
            String storedAccessPermission = jsonObject.has("accessPermission") ? jsonObject.getString("accessPermission") : null;
            globalSettings.setAccessPermission(storedAccessPermission == null || storedAccessPermission.isEmpty() ? defaultSettings.getAccessPermission() : storedAccessPermission);
            String storedInitialfundsRequestMessage = jsonObject.has("initialFundsRequestMessage") ? jsonObject.getString("initialFundsRequestMessage") : null;
            globalSettings.setInitialFundsRequestMessage(storedInitialfundsRequestMessage == null || storedInitialfundsRequestMessage.isEmpty() ? defaultSettings.getInitialFundsRequestMessage() : storedInitialfundsRequestMessage);
            String storedProviderURL = jsonObject.has("providerURL") ? jsonObject.getString("providerURL") : null;
            globalSettings.setProviderURL(storedProviderURL == null || storedProviderURL.isEmpty() ? defaultSettings.getProviderURL() : storedProviderURL);
            String storedWebsocketProviderURL = jsonObject.has("websocketProviderURL") ? jsonObject.getString("websocketProviderURL") : null;
            globalSettings.setWebsocketProviderURL(storedWebsocketProviderURL == null || storedWebsocketProviderURL.isEmpty() ? defaultSettings.getProviderURL() : storedWebsocketProviderURL);
            int storedDefaultBlocksToRetrieve = jsonObject.has("defaultBlocksToRetrieve") ? jsonObject.getInt("defaultBlocksToRetrieve") : 0;
            globalSettings.setDefaultBlocksToRetrieve(storedDefaultBlocksToRetrieve == 0 ? defaultSettings.getDefaultBlocksToRetrieve() : storedDefaultBlocksToRetrieve);
            long storedDefaultNetworkId = jsonObject.has("defaultNetworkId") ? jsonObject.getLong("defaultNetworkId") : 0L;
            globalSettings.setDefaultNetworkId(storedDefaultNetworkId == 0L ? (long)defaultSettings.getDefaultBlocksToRetrieve().intValue() : storedDefaultNetworkId);
            int storedDefaultGas = jsonObject.has("defaultGas") ? jsonObject.getInt("defaultGas") : 0;
            globalSettings.setDefaultGas(storedDefaultGas == 0 ? defaultSettings.getDefaultGas() : storedDefaultGas);
            boolean storedEnableDelegation = jsonObject.has("enableDelegation") ? jsonObject.getBoolean("enableDelegation") : true;
            globalSettings.setEnableDelegation(storedEnableDelegation);
            String storedDefaultPrincipalAccount = jsonObject.has("defaultPrincipalAccount") ? jsonObject.getString("defaultPrincipalAccount") : null;
            globalSettings.setDefaultPrincipalAccount(storedDefaultPrincipalAccount);
            globalSettings.setDefaultOverviewAccounts(Utils.jsonArrayToList(jsonObject, "defaultOverviewAccounts"));
            return globalSettings;
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting JSON String to Object", e);
        }
    }

    public static final GlobalSettings parseStringToObject(String jsonString) {
        return GlobalSettings.parseStringToObject(null, jsonString);
    }

    private static Map<String, Double> toMap(JSONArray storedInitialFunds) throws JSONException {
        HashMap<String, Double> map = new HashMap<String, Double>();
        if (storedInitialFunds == null || storedInitialFunds.length() == 0) {
            return map;
        }
        for (int i = 0; i < storedInitialFunds.length(); ++i) {
            JSONObject obj = storedInitialFunds.getJSONObject(i);
            map.put(obj.getString("address"), obj.getDouble("amount"));
        }
        return map;
    }

    public boolean isWalletEnabled() {
        return this.walletEnabled;
    }

    public boolean isEnableDelegation() {
        return this.enableDelegation;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public String getAccessPermission() {
        return this.accessPermission;
    }

    public String getFundsHolder() {
        return this.fundsHolder;
    }

    public String getInitialFundsRequestMessage() {
        return this.initialFundsRequestMessage;
    }

    public String getFundsHolderType() {
        return this.fundsHolderType;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public String getWebsocketProviderURL() {
        return this.websocketProviderURL;
    }

    public Integer getDefaultBlocksToRetrieve() {
        return this.defaultBlocksToRetrieve;
    }

    public Long getDefaultNetworkId() {
        return this.defaultNetworkId;
    }

    public Integer getDefaultGas() {
        return this.defaultGas;
    }

    public String getDefaultPrincipalAccount() {
        return this.defaultPrincipalAccount;
    }

    public List<String> getDefaultOverviewAccounts() {
        return this.defaultOverviewAccounts;
    }

    public Map<String, Double> getInitialFunds() {
        return this.initialFunds;
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public List<String> getDefaultContractsToDisplay() {
        return this.defaultContractsToDisplay;
    }

    public JSONArray getContractAbi() {
        return this.contractAbi;
    }

    public String getContractBin() {
        return this.contractBin;
    }

    public void setWalletEnabled(boolean walletEnabled) {
        this.walletEnabled = walletEnabled;
    }

    public void setEnableDelegation(boolean enableDelegation) {
        this.enableDelegation = enableDelegation;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setAccessPermission(String accessPermission) {
        this.accessPermission = accessPermission;
    }

    public void setFundsHolder(String fundsHolder) {
        this.fundsHolder = fundsHolder;
    }

    public void setInitialFundsRequestMessage(String initialFundsRequestMessage) {
        this.initialFundsRequestMessage = initialFundsRequestMessage;
    }

    public void setFundsHolderType(String fundsHolderType) {
        this.fundsHolderType = fundsHolderType;
    }

    public void setProviderURL(String providerURL) {
        this.providerURL = providerURL;
    }

    public void setWebsocketProviderURL(String websocketProviderURL) {
        this.websocketProviderURL = websocketProviderURL;
    }

    public void setDefaultBlocksToRetrieve(Integer defaultBlocksToRetrieve) {
        this.defaultBlocksToRetrieve = defaultBlocksToRetrieve;
    }

    public void setDefaultNetworkId(Long defaultNetworkId) {
        this.defaultNetworkId = defaultNetworkId;
    }

    public void setDefaultGas(Integer defaultGas) {
        this.defaultGas = defaultGas;
    }

    public void setDefaultPrincipalAccount(String defaultPrincipalAccount) {
        this.defaultPrincipalAccount = defaultPrincipalAccount;
    }

    public void setDefaultOverviewAccounts(List<String> defaultOverviewAccounts) {
        this.defaultOverviewAccounts = defaultOverviewAccounts;
    }

    public void setInitialFunds(Map<String, Double> initialFunds) {
        this.initialFunds = initialFunds;
    }

    public void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
    }

    public void setDefaultContractsToDisplay(List<String> defaultContractsToDisplay) {
        this.defaultContractsToDisplay = defaultContractsToDisplay;
    }

    public void setContractAbi(JSONArray contractAbi) {
        this.contractAbi = contractAbi;
    }

    public void setContractBin(String contractBin) {
        this.contractBin = contractBin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalSettings)) {
            return false;
        }
        GlobalSettings other = (GlobalSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isWalletEnabled() != other.isWalletEnabled()) {
            return false;
        }
        if (this.isEnableDelegation() != other.isEnableDelegation()) {
            return false;
        }
        if (this.isAdmin() != other.isAdmin()) {
            return false;
        }
        String this$accessPermission = this.getAccessPermission();
        String other$accessPermission = other.getAccessPermission();
        if (this$accessPermission == null ? other$accessPermission != null : !this$accessPermission.equals(other$accessPermission)) {
            return false;
        }
        String this$fundsHolder = this.getFundsHolder();
        String other$fundsHolder = other.getFundsHolder();
        if (this$fundsHolder == null ? other$fundsHolder != null : !this$fundsHolder.equals(other$fundsHolder)) {
            return false;
        }
        String this$initialFundsRequestMessage = this.getInitialFundsRequestMessage();
        String other$initialFundsRequestMessage = other.getInitialFundsRequestMessage();
        if (this$initialFundsRequestMessage == null ? other$initialFundsRequestMessage != null : !this$initialFundsRequestMessage.equals(other$initialFundsRequestMessage)) {
            return false;
        }
        String this$fundsHolderType = this.getFundsHolderType();
        String other$fundsHolderType = other.getFundsHolderType();
        if (this$fundsHolderType == null ? other$fundsHolderType != null : !this$fundsHolderType.equals(other$fundsHolderType)) {
            return false;
        }
        String this$providerURL = this.getProviderURL();
        String other$providerURL = other.getProviderURL();
        if (this$providerURL == null ? other$providerURL != null : !this$providerURL.equals(other$providerURL)) {
            return false;
        }
        String this$websocketProviderURL = this.getWebsocketProviderURL();
        String other$websocketProviderURL = other.getWebsocketProviderURL();
        if (this$websocketProviderURL == null ? other$websocketProviderURL != null : !this$websocketProviderURL.equals(other$websocketProviderURL)) {
            return false;
        }
        Integer this$defaultBlocksToRetrieve = this.getDefaultBlocksToRetrieve();
        Integer other$defaultBlocksToRetrieve = other.getDefaultBlocksToRetrieve();
        if (this$defaultBlocksToRetrieve == null ? other$defaultBlocksToRetrieve != null : !((Object)this$defaultBlocksToRetrieve).equals(other$defaultBlocksToRetrieve)) {
            return false;
        }
        Long this$defaultNetworkId = this.getDefaultNetworkId();
        Long other$defaultNetworkId = other.getDefaultNetworkId();
        if (this$defaultNetworkId == null ? other$defaultNetworkId != null : !((Object)this$defaultNetworkId).equals(other$defaultNetworkId)) {
            return false;
        }
        Integer this$defaultGas = this.getDefaultGas();
        Integer other$defaultGas = other.getDefaultGas();
        if (this$defaultGas == null ? other$defaultGas != null : !((Object)this$defaultGas).equals(other$defaultGas)) {
            return false;
        }
        String this$defaultPrincipalAccount = this.getDefaultPrincipalAccount();
        String other$defaultPrincipalAccount = other.getDefaultPrincipalAccount();
        if (this$defaultPrincipalAccount == null ? other$defaultPrincipalAccount != null : !this$defaultPrincipalAccount.equals(other$defaultPrincipalAccount)) {
            return false;
        }
        List<String> this$defaultOverviewAccounts = this.getDefaultOverviewAccounts();
        List<String> other$defaultOverviewAccounts = other.getDefaultOverviewAccounts();
        if (this$defaultOverviewAccounts == null ? other$defaultOverviewAccounts != null : !((Object)this$defaultOverviewAccounts).equals(other$defaultOverviewAccounts)) {
            return false;
        }
        Map<String, Double> this$initialFunds = this.getInitialFunds();
        Map<String, Double> other$initialFunds = other.getInitialFunds();
        if (this$initialFunds == null ? other$initialFunds != null : !((Object)this$initialFunds).equals(other$initialFunds)) {
            return false;
        }
        UserPreferences this$userPreferences = this.getUserPreferences();
        UserPreferences other$userPreferences = other.getUserPreferences();
        if (this$userPreferences == null ? other$userPreferences != null : !((Object)this$userPreferences).equals(other$userPreferences)) {
            return false;
        }
        List<String> this$defaultContractsToDisplay = this.getDefaultContractsToDisplay();
        List<String> other$defaultContractsToDisplay = other.getDefaultContractsToDisplay();
        if (this$defaultContractsToDisplay == null ? other$defaultContractsToDisplay != null : !((Object)this$defaultContractsToDisplay).equals(other$defaultContractsToDisplay)) {
            return false;
        }
        JSONArray this$contractAbi = this.getContractAbi();
        JSONArray other$contractAbi = other.getContractAbi();
        if (this$contractAbi == null ? other$contractAbi != null : !this$contractAbi.equals(other$contractAbi)) {
            return false;
        }
        String this$contractBin = this.getContractBin();
        String other$contractBin = other.getContractBin();
        return !(this$contractBin == null ? other$contractBin != null : !this$contractBin.equals(other$contractBin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWalletEnabled() ? 79 : 97);
        result = result * 59 + (this.isEnableDelegation() ? 79 : 97);
        result = result * 59 + (this.isAdmin() ? 79 : 97);
        String $accessPermission = this.getAccessPermission();
        result = result * 59 + ($accessPermission == null ? 43 : $accessPermission.hashCode());
        String $fundsHolder = this.getFundsHolder();
        result = result * 59 + ($fundsHolder == null ? 43 : $fundsHolder.hashCode());
        String $initialFundsRequestMessage = this.getInitialFundsRequestMessage();
        result = result * 59 + ($initialFundsRequestMessage == null ? 43 : $initialFundsRequestMessage.hashCode());
        String $fundsHolderType = this.getFundsHolderType();
        result = result * 59 + ($fundsHolderType == null ? 43 : $fundsHolderType.hashCode());
        String $providerURL = this.getProviderURL();
        result = result * 59 + ($providerURL == null ? 43 : $providerURL.hashCode());
        String $websocketProviderURL = this.getWebsocketProviderURL();
        result = result * 59 + ($websocketProviderURL == null ? 43 : $websocketProviderURL.hashCode());
        Integer $defaultBlocksToRetrieve = this.getDefaultBlocksToRetrieve();
        result = result * 59 + ($defaultBlocksToRetrieve == null ? 43 : ((Object)$defaultBlocksToRetrieve).hashCode());
        Long $defaultNetworkId = this.getDefaultNetworkId();
        result = result * 59 + ($defaultNetworkId == null ? 43 : ((Object)$defaultNetworkId).hashCode());
        Integer $defaultGas = this.getDefaultGas();
        result = result * 59 + ($defaultGas == null ? 43 : ((Object)$defaultGas).hashCode());
        String $defaultPrincipalAccount = this.getDefaultPrincipalAccount();
        result = result * 59 + ($defaultPrincipalAccount == null ? 43 : $defaultPrincipalAccount.hashCode());
        List<String> $defaultOverviewAccounts = this.getDefaultOverviewAccounts();
        result = result * 59 + ($defaultOverviewAccounts == null ? 43 : ((Object)$defaultOverviewAccounts).hashCode());
        Map<String, Double> $initialFunds = this.getInitialFunds();
        result = result * 59 + ($initialFunds == null ? 43 : ((Object)$initialFunds).hashCode());
        UserPreferences $userPreferences = this.getUserPreferences();
        result = result * 59 + ($userPreferences == null ? 43 : ((Object)$userPreferences).hashCode());
        List<String> $defaultContractsToDisplay = this.getDefaultContractsToDisplay();
        result = result * 59 + ($defaultContractsToDisplay == null ? 43 : ((Object)$defaultContractsToDisplay).hashCode());
        JSONArray $contractAbi = this.getContractAbi();
        result = result * 59 + ($contractAbi == null ? 43 : $contractAbi.hashCode());
        String $contractBin = this.getContractBin();
        result = result * 59 + ($contractBin == null ? 43 : $contractBin.hashCode());
        return result;
    }
}

