/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.model;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserPreferences
implements Serializable {
    private static final long serialVersionUID = -5725443183560646198L;
    private Integer defaultGas = 0;
    private String currency = "usd";
    private String walletAddress = null;
    private String phrase = null;
    private String principalAccount = null;
    private List<String> overviewAccounts = null;
    private Boolean enableDelegation = null;

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("currency", (Object)this.currency);
            jsonObject.put("defaultGas", (Object)this.defaultGas);
            jsonObject.put("walletAddress", (Object)this.walletAddress);
            jsonObject.put("phrase", (Object)this.phrase);
            if (this.enableDelegation != null) {
                jsonObject.put("enableDelegation", (Object)this.enableDelegation);
            }
            if (this.principalAccount != null) {
                jsonObject.put("principalAccount", (Object)this.principalAccount);
            }
            if (this.overviewAccounts != null) {
                jsonObject.put("overviewAccounts", (Object)new JSONArray(this.overviewAccounts));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public static final UserPreferences parseStringToObject(String jsonString) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            UserPreferences userPreferences = new UserPreferences();
            if (jsonObject.has("currency")) {
                userPreferences.setCurrency(jsonObject.getString("currency"));
            }
            if (jsonObject.has("defaultGas")) {
                userPreferences.setDefaultGas(jsonObject.getInt("defaultGas"));
            }
            if (jsonObject.has("walletAddress")) {
                userPreferences.setWalletAddress(jsonObject.getString("walletAddress"));
            }
            if (jsonObject.has("phrase")) {
                userPreferences.setWalletAddress(jsonObject.getString("phrase"));
            }
            if (jsonObject.has("principalAccount")) {
                userPreferences.setPrincipalAccount(jsonObject.getString("principalAccount"));
            }
            if (jsonObject.has("enableDelegation")) {
                userPreferences.setEnableDelegation(jsonObject.getBoolean("enableDelegation"));
            }
            userPreferences.setOverviewAccounts(Utils.jsonArrayToList(jsonObject, "overviewAccounts"));
            return userPreferences;
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting JSON String to Object", e);
        }
    }

    public String toString() {
        return this.toJSONString();
    }

    public Integer getDefaultGas() {
        return this.defaultGas;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getWalletAddress() {
        return this.walletAddress;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public String getPrincipalAccount() {
        return this.principalAccount;
    }

    public List<String> getOverviewAccounts() {
        return this.overviewAccounts;
    }

    public Boolean getEnableDelegation() {
        return this.enableDelegation;
    }

    public void setDefaultGas(Integer defaultGas) {
        this.defaultGas = defaultGas;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setWalletAddress(String walletAddress) {
        this.walletAddress = walletAddress;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public void setPrincipalAccount(String principalAccount) {
        this.principalAccount = principalAccount;
    }

    public void setOverviewAccounts(List<String> overviewAccounts) {
        this.overviewAccounts = overviewAccounts;
    }

    public void setEnableDelegation(Boolean enableDelegation) {
        this.enableDelegation = enableDelegation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserPreferences)) {
            return false;
        }
        UserPreferences other = (UserPreferences)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$defaultGas = this.getDefaultGas();
        Integer other$defaultGas = other.getDefaultGas();
        if (this$defaultGas == null ? other$defaultGas != null : !((Object)this$defaultGas).equals(other$defaultGas)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$walletAddress = this.getWalletAddress();
        String other$walletAddress = other.getWalletAddress();
        if (this$walletAddress == null ? other$walletAddress != null : !this$walletAddress.equals(other$walletAddress)) {
            return false;
        }
        String this$phrase = this.getPhrase();
        String other$phrase = other.getPhrase();
        if (this$phrase == null ? other$phrase != null : !this$phrase.equals(other$phrase)) {
            return false;
        }
        String this$principalAccount = this.getPrincipalAccount();
        String other$principalAccount = other.getPrincipalAccount();
        if (this$principalAccount == null ? other$principalAccount != null : !this$principalAccount.equals(other$principalAccount)) {
            return false;
        }
        List<String> this$overviewAccounts = this.getOverviewAccounts();
        List<String> other$overviewAccounts = other.getOverviewAccounts();
        if (this$overviewAccounts == null ? other$overviewAccounts != null : !((Object)this$overviewAccounts).equals(other$overviewAccounts)) {
            return false;
        }
        Boolean this$enableDelegation = this.getEnableDelegation();
        Boolean other$enableDelegation = other.getEnableDelegation();
        return !(this$enableDelegation == null ? other$enableDelegation != null : !((Object)this$enableDelegation).equals(other$enableDelegation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserPreferences;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $defaultGas = this.getDefaultGas();
        result = result * 59 + ($defaultGas == null ? 43 : ((Object)$defaultGas).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $walletAddress = this.getWalletAddress();
        result = result * 59 + ($walletAddress == null ? 43 : $walletAddress.hashCode());
        String $phrase = this.getPhrase();
        result = result * 59 + ($phrase == null ? 43 : $phrase.hashCode());
        String $principalAccount = this.getPrincipalAccount();
        result = result * 59 + ($principalAccount == null ? 43 : $principalAccount.hashCode());
        List<String> $overviewAccounts = this.getOverviewAccounts();
        result = result * 59 + ($overviewAccounts == null ? 43 : ((Object)$overviewAccounts).hashCode());
        Boolean $enableDelegation = this.getEnableDelegation();
        result = result * 59 + ($enableDelegation == null ? 43 : ((Object)$enableDelegation).hashCode());
        return result;
    }
}

