/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetail;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.TransactionStatus;
import org.exoplatform.addon.ethereum.wallet.service.utils.FakeHTTPServletRequest;
import org.exoplatform.addon.ethereum.wallet.service.utils.FakeHTTPServletResponse;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalApplication;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.generated.Uint256;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger(Utils.class);
    public static final String ADMINISTRATORS_GROUP = "/platform/administrators";
    public static final String SPACE_ACCOUNT_TYPE = "space";
    public static final String USER_ACCOUNT_TYPE = "user";
    public static final String GLOAL_SETTINGS_CHANGED_EVENT = "exo.addon.wallet.settings.changed";
    public static final String NEW_ADDRESS_ASSOCIATED_EVENT = "exo.addon.wallet.addressAssociation.new";
    public static final String MODIFY_ADDRESS_ASSOCIATED_EVENT = "exo.addon.wallet.addressAssociation.modification";
    public static final String UPGRADE_NOTIFICATION_SETTINGS = "exo.addon.wallet.notification.upgrade";
    public static final String NEW_TRANSACTION_EVENT = "exo.addon.wallet.transaction.loaded";
    public static final String NEW_BLOCK_EVENT = "exo.addon.wallet.block.loaded";
    public static final String WALLET_SENDER_NOTIFICATION_ID = "EtherSenderNotificationPlugin";
    public static final String WALLET_RECEIVER_NOTIFICATION_ID = "EtherReceiverNotificationPlugin";
    public static final String DEPRECATED_SENDER_NOTIFICATION_ID = "ContractSenderNotificationPlugin";
    public static final String DEPRECATED_RECEIVER_NOTIFICATION_ID = "ContractReceiverNotificationPlugin";
    public static final String FUNDS_REQUEST_NOTIFICATION_ID = "FundsRequestNotificationPlugin";
    public static final String FUNDS_REQUEST_SENT = "sent";
    public static final String AMOUNT = "amount";
    public static final String SYMBOL = "symbol";
    public static final String MESSAGE = "message";
    public static final String HASH = "hash";
    public static final String ACCOUNT_TYPE = "account_type";
    public static final String AVATAR = "avatar";
    public static final String SENDER = "sender";
    public static final String USER = "userFullname";
    public static final String USER_URL = "userUrl";
    public static final String SENDER_URL = "senderUrl";
    public static final String RECEIVER = "receiver";
    public static final String RECEIVER_URL = "receiverUrl";
    public static final String FUNDS_ACCEPT_URL = "fundsAcceptUrl";
    public static final ArgumentLiteral<AccountDetail> FUNDS_REQUEST_SENDER_DETAIL_PARAMETER = new ArgumentLiteral(AccountDetail.class, "senderFullName");
    public static final ArgumentLiteral<AccountDetail> SENDER_ACCOUNT_DETAIL_PARAMETER = new ArgumentLiteral(AccountDetail.class, "senderAccountDetail");
    public static final ArgumentLiteral<AccountDetail> RECEIVER_ACCOUNT_DETAIL_PARAMETER = new ArgumentLiteral(AccountDetail.class, "receiverAccountDetail");
    public static final ArgumentLiteral<FundsRequest> FUNDS_REQUEST_PARAMETER = new ArgumentLiteral(FundsRequest.class, "fundsRequest");
    public static final ArgumentLiteral<TransactionStatus> TRANSACTION_STATUS_PARAMETER = new ArgumentLiteral(TransactionStatus.class, "transactionStatus");
    public static final ArgumentLiteral<ContractDetail> CONTRACT_DETAILS_PARAMETER = new ArgumentLiteral(ContractDetail.class, "contractDetails");
    public static final ArgumentLiteral<Double> AMOUNT_PARAMETER = new ArgumentLiteral(Double.class, "amount");
    public static final ArgumentLiteral<String> MESSAGE_PARAMETER = new ArgumentLiteral(String.class, "message");
    public static final ArgumentLiteral<String> HASH_PARAMETER = new ArgumentLiteral(String.class, "hash");
    public static final ArgumentLiteral<String> SYMBOL_PARAMETER = new ArgumentLiteral(String.class, "symbol");
    public static final Event CONTRACT_TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event CONTRACT_APPROVE_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));

    public static final String getCurrentUserId() {
        if (ConversationState.getCurrent() != null && ConversationState.getCurrent().getIdentity() != null) {
            return ConversationState.getCurrent().getIdentity().getUserId();
        }
        return null;
    }

    public static Event approvalEvent() {
        return new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    }

    public static List<String> getNotificationReceiversUsers(AccountDetail toAccount, String excludedId) {
        if (SPACE_ACCOUNT_TYPE.equals(toAccount.getType())) {
            Space space = Utils.getSpace(toAccount.getId());
            if (space == null) {
                return Collections.singletonList(toAccount.getId());
            }
            String[] members = space.getMembers();
            if (members == null || members.length == 0) {
                return Collections.emptyList();
            }
            if (StringUtils.isBlank((CharSequence)excludedId)) {
                return Arrays.asList(members);
            }
            return Arrays.stream(members).filter(member -> !excludedId.equals(member)).collect(Collectors.toList());
        }
        return Collections.singletonList(toAccount.getId());
    }

    public static String getPermanentLink(AccountDetail account) {
        String profileLink = null;
        try {
            profileLink = account.getId() == null || account.getType() == null ? account.getName() : (USER_ACCOUNT_TYPE.equals(account.getType()) ? LinkProvider.getProfileLink((String)account.getId()) : Utils.getPermanentLink(Utils.getSpacePrettyName(account.getId()), account.getName()));
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting profile link of space", (Throwable)e);
        }
        return profileLink;
    }

    public static String getSpacePrettyName(String id) {
        Space space = Utils.getSpace(id);
        return space == null ? id : space.getPrettyName();
    }

    public static Space getSpace(String id) {
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        if (id.indexOf("/spaces/") >= 0) {
            return spaceService.getSpaceByGroupId(id);
        }
        Space space = spaceService.getSpaceByPrettyName(id);
        if (space == null && (space = spaceService.getSpaceByGroupId("/spaces/" + id)) == null && (space = spaceService.getSpaceByDisplayName(id)) == null) {
            space = spaceService.getSpaceByUrl(id);
        }
        return space;
    }

    public static String getAbsoluteMyWalletLink() {
        return CommonsUtils.getCurrentDomain() + Utils.getMyWalletLink();
    }

    public static String getMyWalletLink() {
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)CommonsUtils.getService(UserPortalConfigService.class);
        return "/" + PortalContainer.getInstance().getName() + "/" + userPortalConfigService.getDefaultPortal() + "/wallet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPermanentLink(String prettyName, String name) {
        WebAppController webAppController = (WebAppController)CommonsUtils.getService(WebAppController.class);
        ControllerContext controllerContext = new ControllerContext(webAppController, webAppController.getRouter(), (HttpServletRequest)new FakeHTTPServletResponse(), (HttpServletResponse)new FakeHTTPServletRequest(), null);
        PortalApplication application = (PortalApplication)webAppController.getApplication("PortalApplication");
        PortalRequestContext requestContext = new PortalRequestContext((WebuiApplication)application, controllerContext, SiteType.PORTAL.toString(), "", "", null);
        WebuiRequestContext.setCurrentInstance((RequestContext)requestContext);
        try {
            String spaceUrl = LinkProvider.getSpaceUri((String)prettyName);
            if (StringUtils.isBlank((CharSequence)spaceUrl)) {
                String string = CommonsUtils.getCurrentDomain();
                return string;
            }
            spaceUrl = CommonsUtils.getCurrentDomain() + spaceUrl;
            String string = "<a href=\"" + spaceUrl + "\" target=\"_parent\">" + StringEscapeUtils.escapeHtml((String)name) + "</a>";
            return string;
        }
        finally {
            WebuiRequestContext.setCurrentInstance(null);
        }
    }

    public static List<String> jsonArrayToList(JSONObject jsonObject, String key) throws JSONException {
        ArrayList<String> list = null;
        if (jsonObject.has(key)) {
            list = new ArrayList<String>();
            JSONArray arrayValue = jsonObject.getJSONArray(key);
            for (int i = 0; i < arrayValue.length(); ++i) {
                list.add(arrayValue.getString(i));
            }
        }
        return list;
    }
}

