/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.model;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ContractDetail
implements Serializable {
    private static final long serialVersionUID = 1459881604949041768L;
    private String address;
    private String name;
    private String symbol;
    private Integer decimals;
    private Long networkId;

    public ContractDetail() {
    }

    public ContractDetail(Long networkId, String address, String name, String symbol, Integer decimals) {
        this.networkId = networkId;
        this.address = address;
        this.name = name;
        this.symbol = symbol;
    }

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("address", (Object)this.address);
            jsonObject.put("name", (Object)this.name);
            jsonObject.put("symbol", (Object)this.symbol);
            jsonObject.put("decimals", (Object)this.decimals);
            jsonObject.put("networkId", (Object)this.networkId);
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public static final ContractDetail parseStringToObject(String jsonString) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            ContractDetail contractDetail = new ContractDetail();
            contractDetail.setNetworkId(jsonObject.getLong("networkId"));
            contractDetail.setAddress(jsonObject.getString("address"));
            contractDetail.setName(jsonObject.getString("name"));
            contractDetail.setSymbol(jsonObject.getString("symbol"));
            contractDetail.setDecimals(jsonObject.has("decimals") ? jsonObject.getInt("decimals") : 0);
            return contractDetail;
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting JSON String to Object", e);
        }
    }

    public String toString() {
        return this.toJSONString();
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Integer getDecimals() {
        return this.decimals;
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public void setNetworkId(Long networkId) {
        this.networkId = networkId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractDetail)) {
            return false;
        }
        ContractDetail other = (ContractDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        Integer this$decimals = this.getDecimals();
        Integer other$decimals = other.getDecimals();
        if (this$decimals == null ? other$decimals != null : !((Object)this$decimals).equals(other$decimals)) {
            return false;
        }
        Long this$networkId = this.getNetworkId();
        Long other$networkId = other.getNetworkId();
        return !(this$networkId == null ? other$networkId != null : !((Object)this$networkId).equals(other$networkId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContractDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        Integer $decimals = this.getDecimals();
        result = result * 59 + ($decimals == null ? 43 : ((Object)$decimals).hashCode());
        Long $networkId = this.getNetworkId();
        result = result * 59 + ($networkId == null ? 43 : ((Object)$networkId).hashCode());
        return result;
    }
}

