/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetail;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.TransactionMessage;
import org.exoplatform.addon.ethereum.wallet.model.UserPreferences;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/wallet/api/account")
@RolesAllowed(value={"users"})
public class EthereumWalletAccountREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletAccountREST.class);
    private EthereumWalletService ethereumWalletService;

    public EthereumWalletAccountREST(EthereumWalletService ethereumWalletService) {
        this.ethereumWalletService = ethereumWalletService;
    }

    @Path(value="detailsById")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getAccountByTypeAndID(@QueryParam(value="id") String id, @QueryParam(value="type") String type) {
        if (StringUtils.isBlank((String)id) || StringUtils.isBlank((String)type) || !StringUtils.equals((String)type, (String)"user") && !StringUtils.equals((String)type, (String)"space")) {
            LOG.warn("Bad request sent to server with id '{}' and type '{}'", new Object[]{id, type});
            return Response.status((int)400).build();
        }
        if (StringUtils.equals((String)type, (String)"user")) {
            AccountDetail accountDetail = this.ethereumWalletService.getUserDetails(id);
            if (accountDetail == null) {
                LOG.warn("User not found with id '{}'", new Object[]{id});
                return Response.status((int)400).build();
            }
            accountDetail.setAddress(this.ethereumWalletService.getUserAddress(id));
            return Response.ok((Object)accountDetail).build();
        }
        if (StringUtils.equals((String)type, (String)"space")) {
            AccountDetail accountDetail = this.ethereumWalletService.getSpaceDetails(id);
            if (accountDetail == null) {
                LOG.warn("Space not found with id '{}'", new Object[]{id});
                return Response.status((int)400).build();
            }
            accountDetail.setAddress(this.ethereumWalletService.getSpaceAddress(id));
            return Response.ok((Object)accountDetail).build();
        }
        return Response.ok((Object)"{}").build();
    }

    @Path(value="detailsByAddress")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getAccountByAddress(@QueryParam(value="address") String address) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn("Bad request sent to server with empty address {}", new Object[]{address});
            return Response.status((int)400).build();
        }
        AccountDetail accountDetail = this.ethereumWalletService.getAccountDetailsByAddress(address = address.toLowerCase());
        return Response.ok((Object)(accountDetail == null ? "{}" : accountDetail)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="saveAddress")
    @RolesAllowed(value={"users"})
    public Response saveAddress(AccountDetail accountDetail) {
        if (accountDetail == null) {
            LOG.warn((Object)"Bad request sent to server with empty data");
            return Response.status((int)400).build();
        }
        LOG.info("User '{}' is saving new wallet address for {} '{}' with address '{}'", new Object[]{Utils.getCurrentUserId(), accountDetail.getType(), accountDetail.getId(), accountDetail.getAddress()});
        try {
            String securityPhrase = this.ethereumWalletService.saveWalletAddress(accountDetail);
            return Response.ok((Object)securityPhrase).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)403).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while saving address: User " + Utils.getCurrentUserId() + " attempts to save address of " + accountDetail.getType() + " '" + accountDetail.getId() + "' using address " + accountDetail.getAddress()), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="savePreferences")
    @RolesAllowed(value={"users"})
    public Response savePreferences(UserPreferences userPreferences) {
        if (userPreferences == null) {
            LOG.warn((Object)"Bad request sent to server with empty preferenes");
            return Response.status((int)400).build();
        }
        Integer defaultGas = userPreferences.getDefaultGas();
        if (defaultGas == null || defaultGas == 0) {
            LOG.warn("Bad request sent to server with invalid preferenes defaultGas '{}'", new Object[]{defaultGas});
            return Response.status((int)400).build();
        }
        LOG.info("Saving user preferences '{}'", new Object[]{Utils.getCurrentUserId()});
        try {
            this.ethereumWalletService.saveUserPreferences(Utils.getCurrentUserId(), userPreferences);
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while saving user preferences '" + Utils.getCurrentUserId() + "'"), (Throwable)e);
            return Response.status((int)500).build();
        }
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="requestFunds")
    @RolesAllowed(value={"users"})
    public Response requestFunds(FundsRequest fundsRequest) {
        if (fundsRequest == null) {
            LOG.warn((Object)"Bad request sent to server with empty funds request");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)fundsRequest.getAddress())) {
            LOG.warn((Object)"Bad request sent to server with empty sender address");
            return Response.status((int)400).build();
        }
        String receipientRemoteId = fundsRequest.getReceipient();
        String receipientType = fundsRequest.getReceipientType();
        if (StringUtils.isBlank((String)receipientRemoteId) || StringUtils.isBlank((String)receipientType)) {
            LOG.warn((Object)"Bad request sent to server with empty receipient");
            return Response.status((int)400).build();
        }
        try {
            this.ethereumWalletService.requestFunds(fundsRequest);
        }
        catch (IllegalAccessException e) {
            return Response.status((int)403).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while user '" + Utils.getCurrentUserId() + "' requesting funds for wallet  '" + fundsRequest.getAddress() + "'"), (Throwable)e);
            return Response.status((int)500).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="markFundRequestAsSent")
    @RolesAllowed(value={"users"})
    public Response markFundRequestAsSent(@QueryParam(value="notificationId") String notificationId) {
        if (StringUtils.isBlank((String)notificationId)) {
            LOG.warn((Object)"Bad request sent to server with empty notificationId");
            return Response.status((int)400).build();
        }
        String currentUser = Utils.getCurrentUserId();
        try {
            this.ethereumWalletService.markFundRequestAsSent(notificationId, currentUser);
        }
        catch (IllegalAccessException e) {
            return Response.status((int)403).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while marking fund request with id '" + notificationId + "' for user '" + Utils.getCurrentUserId() + "'"), (Throwable)e);
            return Response.status((int)500).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="fundRequestSent")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    public Response isFundRequestSent(@QueryParam(value="notificationId") String notificationId) {
        if (StringUtils.isBlank((String)notificationId)) {
            LOG.warn((Object)"Bad request sent to server with empty notificationId");
            return Response.status((int)400).build();
        }
        String currentUser = Utils.getCurrentUserId();
        try {
            boolean fundRequestSent = this.ethereumWalletService.isFundRequestSent(notificationId, currentUser);
            return Response.ok((Object)String.valueOf(fundRequestSent)).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)403).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving fund request status", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    @RolesAllowed(value={"administrators"})
    public Response getWallets() {
        try {
            return Response.ok(this.ethereumWalletService.listWallets()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of wallets", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="saveTransactionMessage")
    @RolesAllowed(value={"users"})
    public Response saveTransactionMessage(TransactionMessage transactionMessage) {
        if (transactionMessage == null || StringUtils.isBlank((String)transactionMessage.getHash())) {
            LOG.warn((Object)"Bad request sent to server with empty transaction hash");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)transactionMessage.getSender())) {
            transactionMessage.setSender(Utils.getCurrentUserId());
        }
        try {
            this.ethereumWalletService.saveTransactionMessage(transactionMessage);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving transaction message", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getTransactions")
    @RolesAllowed(value={"users"})
    public Response getTransactions(@QueryParam(value="networkId") long networkId, @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn("Bad request sent to server with empty address {}", new Object[]{address});
            return Response.status((int)400).build();
        }
        if (networkId == 0L) {
            LOG.warn("Bad request sent to server with empty networkId {}", new Object[]{networkId});
            return Response.status((int)400).build();
        }
        List<JSONObject> userTransactions = this.ethereumWalletService.getAccountTransactions(networkId, address);
        JSONArray array = new JSONArray(userTransactions);
        return Response.ok((Object)array.toString()).build();
    }
}

