/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationPeriod;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationPeriodType;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationSettings;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationTeam;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationTransaction;
import org.exoplatform.addon.ethereum.wallet.service.WalletGamificationService;
import org.exoplatform.addon.ethereum.wallet.service.utils.GamificationUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/wallet/api/gamification")
public class WalletGamificationREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletGamificationREST.class);
    WalletGamificationService walletGamificationService;

    public WalletGamificationREST(WalletGamificationService walletGamificationService) {
        this.walletGamificationService = walletGamificationService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="settings")
    @RolesAllowed(value={"users"})
    public Response getSettings() {
        return Response.ok((Object)this.walletGamificationService.getSettings()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="teams")
    @RolesAllowed(value={"administrators"})
    public Response getTeams() {
        return Response.ok(this.walletGamificationService.getTeams()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="removeTeam")
    @RolesAllowed(value={"administrators"})
    public Response removeTeam(@QueryParam(value="id") Long id) {
        if (id == null || id == 0L) {
            return Response.status((int)400).build();
        }
        this.walletGamificationService.removeTeam(id);
        return Response.ok().build();
    }

    @POST
    @Path(value="saveSettings")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response saveSettings(GamificationSettings gamificationSettings) {
        if (gamificationSettings == null) {
            LOG.warn((Object)"Bad request sent to server with empty settings");
            return Response.status((int)400).build();
        }
        this.walletGamificationService.saveSettings(gamificationSettings);
        return Response.ok().build();
    }

    @POST
    @Path(value="saveTeam")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response saveTeam(GamificationTeam gamificationTeam) {
        if (gamificationTeam == null) {
            LOG.warn((Object)"Bad request sent to server with empty team");
            return Response.status((int)400).build();
        }
        gamificationTeam = this.walletGamificationService.saveTeam(gamificationTeam);
        return Response.ok((Object)gamificationTeam).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getPeriodTransactions")
    @RolesAllowed(value={"users"})
    public Response getPeriodTransactions(@QueryParam(value="networkId") long networkId, @QueryParam(value="periodType") String periodType, @QueryParam(value="startDateInSeconds") long startDateInSeconds) {
        if (networkId == 0L) {
            LOG.warn("Bad request sent to server with empty networkId {}", new Object[]{networkId});
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)periodType)) {
            LOG.warn("Bad request sent to server with empty periodType {}", new Object[]{periodType});
            return Response.status((int)400).build();
        }
        if (startDateInSeconds == 0L) {
            LOG.warn("Bad request sent to server with empty startDateInSeconds {}", new Object[]{startDateInSeconds});
            return Response.status((int)400).build();
        }
        List<JSONObject> periodTransactions = this.walletGamificationService.getPeriodTransactions(networkId, periodType, startDateInSeconds);
        JSONArray array = new JSONArray(periodTransactions);
        return Response.ok((Object)array.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="savePeriodTransactions")
    @RolesAllowed(value={"users"})
    public Response savePeriodTransactions(List<GamificationTransaction> gamificationTransactions) {
        if (gamificationTransactions == null || gamificationTransactions.isEmpty()) {
            LOG.warn("Bad request sent to server with empty transactions to save: {}", new Object[]{gamificationTransactions});
            return Response.status((int)400).build();
        }
        try {
            for (GamificationTransaction gamificationTransaction : gamificationTransactions) {
                this.walletGamificationService.savePeriodTransaction(gamificationTransaction);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving transaction", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="savePeriodTransaction")
    @RolesAllowed(value={"users"})
    public Response savePeriodTransaction(GamificationTransaction gamificationTransaction) {
        if (gamificationTransaction == null) {
            LOG.warn("Bad request sent to server with empty transaction to save: {}", new Object[]{gamificationTransaction});
            return Response.status((int)400).build();
        }
        try {
            this.walletGamificationService.savePeriodTransaction(gamificationTransaction);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving transaction", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @Path(value="getPeriodDates")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getPeriodDates(@QueryParam(value="periodType") String periodType, @QueryParam(value="dateInSeconds") long dateInSeconds) {
        if (dateInSeconds == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty 'dateInSeconds' parameter");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)periodType)) {
            LOG.warn((Object)"Bad request sent to server with empty 'periodType' parameter");
            return Response.status((int)400).build();
        }
        GamificationPeriodType gamificationPeriodType = GamificationPeriodType.valueOf(periodType);
        GamificationPeriod gamificationPeriod = gamificationPeriodType.getPeriodOfTime(GamificationUtils.timeFromSeconds(dateInSeconds));
        return Response.ok((Object)gamificationPeriod.toString()).build();
    }
}

