/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.TimeZone;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationPeriod;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationPeriodType;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationSettings;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationUtils {
    private static final Log LOG = ExoLogger.getLogger(GamificationUtils.class);

    public static LocalDateTime timeFromSeconds(long createdDate) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(createdDate), TimeZone.getDefault().toZoneId());
    }

    public static long timeToSeconds(LocalDateTime time) {
        return time.atZone(ZoneOffset.systemDefault()).toEpochSecond();
    }

    public static GamificationPeriod getCurrentPeriod(GamificationSettings gamificationSettings) {
        return GamificationUtils.getPeriodOfTime(gamificationSettings, LocalDateTime.now());
    }

    public static GamificationPeriod getPeriodOfTime(GamificationSettings gamificationSettings, LocalDateTime localDateTime) {
        GamificationPeriodType gamificationPeriodType = null;
        if (gamificationSettings == null || gamificationSettings.getPeriodType() == null) {
            LOG.warn((Object)("Provided gamificationSettings doesn't have a parametred gamification period type, using MONTH period type: " + gamificationSettings), (Throwable)new RuntimeException());
            gamificationPeriodType = GamificationPeriodType.DEFAULT;
        } else {
            gamificationPeriodType = gamificationSettings.getPeriodType();
        }
        return gamificationPeriodType.getPeriodOfTime(localDateTime);
    }
}

